<!DOCTYPE html>
<html lang="en">
<head>
   <?php include('./assets/includes/style.php'); ?>
   <link rel="stylesheet" href="./assets/style.css" />
   <style>
       .choose_card {
           margin-bottom: 16px;
       }
       .choose_bx {
           border-radius: 14px;
           background-color: #f2f2ef;
           width: 100%;
           max-width: 568px;
           height: 90px;
           margin: auto;
           cursor: pointer;
           display: flex;
           align-items: center;
           padding: 0;
           overflow: hidden;
       }
       .choose_title {
           font-size: 16px;
           font-weight: 700;
           margin-bottom: 0;
           cursor: pointer;
           display: flex;
           align-items: center;
           justify-content: flex-start;
           width: 100%;
           padding: 0 20px;
       }
       .choose_pic {
           margin-right: 10px;
           font-size: 2em;
       }
       input[type="radio"] {
           display: none;
       }
       input[type="radio"] + label {
           display: flex;
           align-items: center;
           justify-content: flex-start;
           width: 100%;
           height: 100%;
       }
       input[type="radio"]:checked + label {
           background-color: #349760;
           color: #f1f3f5;
           font-weight: 900;
           border-radius: 14px;
       }
   </style>
</head>
<body>
   <?php
   $total_page = 26;
   $current_page = 2;
   include('./assets/includes/header.php');
   ?>
   <form id="quizForm" action="./qA1.2.php" method="post">
       <div class="choose_sec">
           <div class="container">
               <div class="choose_head text-center">
                   <h2>What do you aspire to achieve? (Select multiple goals):</h2>
               </div>
               <?php foreach ($_POST as $key => $value) { echo '<input type="hidden" name="' . $key . '" value="' . $value . '">'; } ?>
               
            <div class="choose_card">
               <div class="choose_bx" onclick="document.getElementById('1_0').checked = true; document.getElementById('quizForm').submit();">
                   <input type="radio" name="q1" value="1_0" id="1_0">
                   <label class="choose_title mb-0" for="1_0">
                       <div class="choose_pic">
                           💪
                       </div>
                       Achieve a toned, firm body
                   </label>
               </div>
            </div>
        
            <div class="choose_card">
               <div class="choose_bx" onclick="document.getElementById('1_1').checked = true; document.getElementById('quizForm').submit();">
                   <input type="radio" name="q1" value="1_1" id="1_1">
                   <label class="choose_title mb-0" for="1_1">
                       <div class="choose_pic">
                           🌟
                       </div>
                       Shed those stubborn pounds
                   </label>
               </div>
            </div>
        
            <div class="choose_card">
               <div class="choose_bx" onclick="document.getElementById('1_2').checked = true; document.getElementById('quizForm').submit();">
                   <input type="radio" name="q1" value="1_2" id="1_2">
                   <label class="choose_title mb-0" for="1_2">
                       <div class="choose_pic">
                           ❤️
                       </div>
                       Improve heart health
                   </label>
               </div>
            </div>
        
            <div class="choose_card">
               <div class="choose_bx" onclick="document.getElementById('1_3').checked = true; document.getElementById('quizForm').submit();">
                   <input type="radio" name="q1" value="1_3" id="1_3">
                   <label class="choose_title mb-0" for="1_3">
                       <div class="choose_pic">
                           🧘‍♂️
                       </div>
                       Relieve stress
                   </label>
               </div>
            </div>
        
           </div>
       </div>
   </form>
   <?php include('./assets/includes/script.php'); ?>
</body>
</html>
