<?php 
    include "dbcon.php";
    session_start();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Stripe Payment Gateway Integration in PHP</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="//netdna.bootstrapcdn.com/bootstrap/3.1.0/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="css/design.css">
    <script src="js/jquery.min.js"></script>
    <script src="//netdna.bootstrapcdn.com/bootstrap/3.1.0/js/bootstrap.min.js"></script>
</head>
<body>
    <div class="container">
        <h2 style="text-align: center; color: blue;">Stripe Payment Gateway Integration in PHP</h2>
        <?php 
            $sql = "SELECT * FROM `products`";
            $res = mysqli_query($con, $sql) or die("MySql Query Error: " . mysqli_error($con));
            if (mysqli_num_rows($res) > 0) {
                while ($row = mysqli_fetch_assoc($res)) {
        ?>
        <form method="post" action="stripe_form.php" class="product-form">
            <div class="col-md-4 column productbox">
                <input type="hidden" name="id" value="<?php echo htmlspecialchars($row['id']); ?>"/>
                <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>"/>
                <img src="<?php echo htmlspecialchars($row['image']); ?>" class="img-responsive">
                <div class="producttitle"><?php echo htmlspecialchars($row['name']); ?></div>
                <div class="productprice">
                    <div class="pull-right">
                        <button type="submit" class="btn btn-primary btn-sm" name="submit" role="button">Buy Now</button>
                    </div>
                    <div class="pricetext">$<?php echo htmlspecialchars($row['price']); ?></div>
                </div>
            </div>
        </form>
        <?php 
                }
            } else {
                echo "<p>No products found.</p>";
            }
        ?>
    </div>
    <script>
        $(document).ready(function() {
            $('.product-form').on('submit', function() {
                var email = localStorage.getItem('userEmail');
                if (email) {
                    $(this).append('<input type="hidden" name="email" value="' + email + '"/>');
                }
            });
        });
    </script>
</body>
</html>
