<?php
session_start();
// Initialize variables
$payment_id = $statusMsg = '';
$ordStatus = 'error';
$id = '';

// Check whether stripe token is not empty
if (!empty($_POST['token'])) {
    
    // Get Token, Card and User Info from Form
    $token = $_POST['token'];  // Use the 'id' field of the token object
    $email = isset($_POST['email']) ? $_POST['email'] : '';

    // Get selected plan
    $selectedPlan = $_POST['selectedPlan'];
    switch ($selectedPlan) {
        case '0.50':
            $setupFee = 50; // $0.50 in cents
            $productName = '6-DAY TRIAL - $0.50';
            break;
        case '3':
            $setupFee = 300; // $3.00 in cents
            $productName = '6-DAY TRIAL - $3.00';
            break;
        case '10':
            $setupFee = 1000; // $10.00 in cents
            $productName = '6-DAY TRIAL - $10.00';
            break;
        case '18.37':
            $setupFee = 1837; // $18.37 in cents
            $productName = '6-DAY TRIAL - $18.37';
            break;
        default:
            // Handle unexpected cases
            $statusMsg = "Invalid plan selected.";
            echo json_encode(['status' => $ordStatus, 'message' => $statusMsg]);
            exit();
    }
    
    $price = 4897; // $48.97 in cents (monthly subscription after trial)
    $planInterval = 'month';
    $trialPeriod = 6 * 24 * 60 * 60; // 6 days in seconds

    // Include Stripe PHP Library
    require_once('stripe-php/init.php');

    // Set your secret key
    \Stripe\Stripe::setApiKey('sk_test_51OuhoIRp9feDzI9FFRzsNuKH6oO9r2AT81yPhgRATKBpufd1cWVXU4dkkNe03BwtON0jiPARS4RaxX67a1f6rVRh00QTOzKorX');

    try {
        // Create a customer in Stripe
        $customer = \Stripe\Customer::create([
            'email' => $email,
            'source' => $token,  // Use the token ID
            'description' => 'Customer for ' . $email
        ]);

        // Charge the customer for setup fee
        $charge = \Stripe\Charge::create([
            'customer' => $customer->id,
            'amount' => $setupFee,
            'currency' => 'usd',
            'description' => 'One-time setup fee'
        ]);

        // Create a product (if not already created)
        $product = \Stripe\Product::create([
            'name' => $productName,
            'type' => 'service',
        ]);

        // Create a plan with the specified price and interval
        $plan = \Stripe\Plan::create([
            'amount' => $price,
            'interval' => $planInterval,
            'product' => $product->id,
            'currency' => 'usd',
        ]);

        // Subscribe the customer to the plan
        $subscription = \Stripe\Subscription::create([
            'customer' => $customer->id,
            'items' => [['plan' => $plan->id]],
            'trial_end' => time() + $trialPeriod, // Set trial period manually
        ]);

        // If everything is successful
        $ordStatus = 'success';
        $statusMsg = 'Your Payment has been Successful!';
        $payment_id = $charge->id;// Payment ID or other identifier
        $_SESSION['payment_id']=$payment_id;
        $_SESSION['email']=$email;
        // Redirect to upsell page
        // header("Location: upsell-1.php");
        // exit();
        
    } catch (Exception $e) {
        $statusMsg = "Transaction has been failed: " . $e->getMessage();
    }
} else {
    $statusMsg = "Error on form submission.";
}

// Prepare JSON response
$response = array(
    'status' => $ordStatus,
    'message' => $statusMsg,
    'payment_id' => $payment_id,
    'email' => $email
);

// Send JSON response back to the AJAX request
header('Content-Type: application/json');
echo json_encode($response);
?>
