<?php

session_start();
// Initialize variables
$payment_id = $statusMsg = '';
$ordStatus = 'error';

// Check whether Stripe token is not empty
if (!empty($_POST['token'])) {
   
    // Get Token, Card, and User Info from Form
    $token = $_POST['token']['id'];
    $name = $_POST['holdername'] ?? '';
    $email = $_POST['email'] ?? '';

    // Retrieve plan details from the form
    $selectedPlan = $_POST['selectedPlan'];

    // Include Stripe PHP Library
    require_once('stripe-php/init.php');

    // Set your secret key: replace this with your actual secret key
    // \Stripe\Stripe::setApiKey('sk_test_51OZ4zdA97tWgKnm11NM5rE96EskJuiZ6xXpXf5hkHpGBTnrtl4GeEVGqZqtaDEdK8JN81nCeWwToMfFVbPwy3zCL00h7Uo4ISd');
    \Stripe\Stripe::setApiKey('sk_test_51OuhoIRp9feDzI9FFRzsNuKH6oO9r2AT81yPhgRATKBpufd1cWVXU4dkkNe03BwtON0jiPARS4RaxX67a1f6rVRh00QTOzKorX');

    try {
        // Create a customer in Stripe
        $customer = \Stripe\Customer::create([
            'email' => $email,
            'source' => $token,
            'description' => '7-day trial customer for ' . $email
        ]);

        // Create a product (if not already created)
        $product = \Stripe\Product::create([
            'name' => 'Monthly Subscription',
            'type' => 'service',
        ]);

        // Create a plan with the specified price and interval for recurring charges
        $plan = \Stripe\Plan::create([
            'amount' => 2999, // $29.99 in cents
            'interval' => 'month',
            'product' => $product->id,
            'currency' => 'usd',
            'trial_period_days' => 6 // 7-day trial
        ]);

        // Subscribe the customer to the plan
        $subscription = \Stripe\Subscription::create([
            'customer' => $customer->id,
            'items' => [['plan' => $plan->id]],
        ]);

        // Charge the setup fee immediately
        $charge = \Stripe\Charge::create([
            'customer' => $customer->id,
            'amount' => $selectedPlan * 100,
            'currency' => 'usd',
            'description' => 'Setup fee for ' . $product->name
        ]);

        // If everything is successful
        $ordStatus = 'success';
        $statusMsg = 'Your Payment has been Successful!';
        $payment_id = $subscription->id; // Use Subscription ID as payment ID

        $_SESSION['payment_id'] = $payment_id;
        $_SESSION['email'] = $email;
        
    } catch (Exception $e) {
        $statusMsg = "Transaction has failed: " . $e->getMessage();
    }
} else {
    $statusMsg = "Error on form submission.";
}

sendResponse($ordStatus, $statusMsg, $payment_id);

function sendResponse($status, $message, $paymentId = null, $email = null) {
    $response = [
        'status' => $status,
        'message' => $message,
        'payment_id' => $paymentId,
        'email' => $email
    ];

    header('Content-Type: application/json');
    echo json_encode($response);
}
?>
