<?php
session_start();


   use Google\Cloud\Firestore\FirestoreClient;
   require('dbconfig.php');
   
   try {
      
       $_POST['paid'] = false;
       $_POST['order_id'] = '';
       $_POST['created_at'] = date("Y-m-d H:i:s");
       $_POST['updated_at'] = '';
       $_POST['email'] = $_SESSION['email'];
       
     
   
       if (!isset($_POST['email']) || empty($_POST['email']) || !filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
           header("location:index.php");
           exit();
       }
   
       $db = new FirestoreClient();
      $docRef = $db->collection('APP')->document($_POST['email']);
     
       $docRef->set($_POST);
   
       $docRef->collection('MeasurementTrackerHistory')->document(date('d M y'))->set([
           'bustInInches' => 25,
           'date' => date('Y-m-d H:i:s'),
           'hipsInInches' => 13,
           'thighInInches' => 41,
           'waistInInches' => 22,
       ]);
   
       $docRef->collection('UserData')->document('UserData')->set([
           'caloriesIntake' => 1100,
           'carbsIntake' => 100,
           'date' => date('Y-m-d H:i:s'),
           'fatIntake' => 60, // Fixed space issue here
           'name' => "User",
           'profileImage' => "https://images.unsplash.com/photo-1481437642641-2f0ae875f836?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1170&q=80",
           'proteinIntake' => 65,
       ]);
   
       $docRef->collection('WeightTrackerHistory')->document(date('d M y'))->set([
           'weightInLbs' => 150,
           'date' => date('Y-m-d H:i:s'),
       ]);
   } catch (Exception $e) {
       echo 'Caught exception: ', $e->getMessage(), "\n";
   }
   
   
   //$_SESSION['user'] = $_POST;
   
   $email = $_POST['email'];
   $type = $_POST['type'];
   
   $weight_measurement = $type == 'in' ? 'lbs' : 'kg';
   $current_weight = $_POST['current_weight'];
   $desired_weight = $_POST['desired_weight'];
   $difference_weight = $current_weight - $desired_weight;
   $lost_per_week = 3;
   $lost_per_month = 12;
   $lost_total_weeks = floor($difference_weight / $lost_per_week);
   $lost_total_months = round($lost_total_weeks / 4);
   
   $today = date("Y-m-d");
   $lost_total_week_date = date('Y-m-d', strtotime($today . ' + ' . $lost_total_weeks . ' weeks'));
   
   ?>
<!DOCTYPE html>
<html lang="en">
   <head>
      <?php include('./assets/includes/style.php'); ?>
      <meta charset="UTF-8">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <title>Personal Plan</title>
      <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
      <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
      <link href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@400;500;700&amp;display=swap" rel="stylesheet">
      <link rel="stylesheet" href="./assets/style-aug-19.css">
      <link rel="stylesheet" href="/./assets/includes/stripe/checkout.css">
      <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
      <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css">
      <style>
         #chart {
         max-width: 650px;
         margin: 35px auto;
         }
         /* new simple site design */
         .user-research-badge[data-v-79d80df4] {
         padding-left: 2.5rem;
         background: url(./image/user-research-badge-icon.svg) no-repeat;
         color: #323653;
         }
         
body {
  font-family: Inter, Roboto, Oxygen, Fira Sans, sans-serif;
  width: 100%;
  height: 100%;
  background-color: #F7F6F3 !important; /* Ensure it's not commented out */
  min-height: 100vh;
}

         .user-research-badge__note[data-v-79d80df4] {
         margin-top: .29rem;
         font-size: .9rem;
         color: #646260;
         }
        
         .order-summary-v2-promocode {
         margin-top: 1rem;
         padding-bottom: 1rem;
         }
         .promocode {
         width: 100%;
         }
         .promocode__open-popup {
         color: #56a97a;
         box-shadow: none;
         margin-top: 1rem;
         width: 100%;
         }
         .btn-success {
         color: #fff;
         background-color: #56a97a;
         border-color: #56a97a;
         width: 100%;
         }
         .container-fluid {
         width: 100%;
         padding-right: 20px;
         padding-left: 20px;
         margin-right: auto;
         margin-left: auto;
         max-width: 500px;
         }
         .app-store_extended {
         padding: 2rem .6rem;
         margin-bottom: 2rem;
         background-color: #f5f6f8;
         border-radius: .75rem;
         }
         .app-store,
         .app-store__stores {
         display: flex;
         align-items: center;
         }
         .app-store {
         flex-direction: column;
         margin-bottom: 2.8rem;
         }
         .app-store__header {
         display: flex;
         align-items: center;
         max-width: 350px;
         margin-bottom: 2rem;
         }
         .app-store_extended .app-store__stores {
         max-width: 100%;
         padding: 1rem;
         background-color: #fff;
         border-radius: 1rem;
         }
         .app-store,
         .app-store__stores {
         display: flex;
         align-items: center;
         }
         .app-store__footer {
         max-width: 350px;
         margin-top: 2rem;
         padding: 0 1rem;
         font-size: 1.2rem;
         font-weight: 700;
         text-align: center;
         }
         /* reviews */
         .title[data-v-63cced3e] {
         font-size: 1.5rem;
         font-weight: 700;
         text-align: center;
         padding: 0 15px;
         line-height: 1.3;
         }
         .review-card[data-v-0d952487] {
         background-color: var(--card-background-color);
         padding: 1.3rem;
         box-shadow: 0 3.50835px 29.4702px rgba(0, 0, 0, .1);
         border-radius: .5rem;
         margin-top: .8rem;
         }
         .comment[data-v-a2fbf3f8] {
         text-align: left;
         }
         .comment__header[data-v-a2fbf3f8] {
         display: flex;
         align-items: center;
         }
         .justify-content-between {
         justify-content: space-between !important;
         }
         .comment__content[data-v-a2fbf3f8] {
         margin-top: .8rem;
         }
         /* reviews */
      </style>
   </head>
   <body>
      <style>
         /* Hide both versions by default and set border color */
         .paywall-diets-vs-fasting-cols,
         .mobile-side-by-side {
         display: none;
         border: 2px solid #F3F4F6 !important;
         /* Ensuring the border color overrides other styles */
         }
         /* Desktop specific styles */
         @media (min-width: 992px) {
         .paywall-diets-vs-fasting-cols {
         display: flex;
         /* Show only the desktop version on larger screens */
         border: 2px solid #F3F4F6 !important;
         /* Ensuring the border color for desktop version */
         }
         .mobile-side-by-side {
         display: none;
         /* Hide mobile version on desktop */
         }
         }
         /* Mobile specific styles */
         @media (max-width: 991px) {
         .paywall-diets-vs-fasting-cols {
         display: none;
         /* Hide desktop version on mobile */
         }
         .mobile-side-by-side {
         display: flex;
         /* Show only the mobile version on smaller screens */
         flex-wrap: nowrap;
         overflow-x: auto;
         /* Allows horizontal scrolling on smaller screens */
         border: 2px solid #F3F4F6 !important;
         /* Ensuring the border color for mobile version */
         }
         .mobile-side-by-side .col-6 {
         flex: 0 0 50%;
         /* Each column takes up half the width of the screen on mobile */
         max-width: 50%;
         }
         }
      </style>
      <style>
         @media (min-width: 768px) {
         .css-ho521d {
         display: flex;
         justify-content: center;
         align-items: center;
         width: var(--container-width, 100%);
         transform: translateX(var(--horizontal-shift, 0%));
         margin: auto;
         padding: 20px;
         background: none;
         border: none;
         }
         .css-79elbk {
         width: 100%;
         max-width: 1200px;
         text-align: center;
         margin-bottom: 20px;
         background: none;
         }
         .css-wyg3yr {
         padding: 10px;
         background-color: transparent;
         box-shadow: none;
         }
         .plan-cehckout-sec {
         display: flex;
         justify-content: center;
         align-items: center;
         padding: 40px;
         box-sizing: border-box;
         width: 100%;
         }
         .container {
         max-width: 1600px;
         width: 100%;
         margin: 0 auto;
         text-align: center;
         }
         .weight-predict-block {
         width: 100%;
         text-align: center;
         }
         .goal-subtitle {
         font-size: 1.5rem; /* Font size for the goal subtitle */
         margin-bottom: 10px; /* Margin below the subtitle */
         text-align: center; /* Center text alignment */
         position: relative; /* Relative positioning to allow for adjustments */
         top: var(--goal-subtitle-top, 0px); /* Control vertical positioning */
         left: var(--goal-subtitle-left, 0px); /* Control horizontal positioning */
         color: var(--goal-subtitle-color, #333); /* Text color for subtitle */
         }
         .weight-predict-title-content {
         display: flex; /* Flex display for easy alignment */
         justify-content: center; /* Center content horizontally */
         align-items: center; /* Center content vertically */
         font-size: 2rem; /* Font size for the title content */
         flex-wrap: wrap;
         }
         .weight-predict-title-content > div:last-child,
         .weight-predict-title-content > span:last-child {
         margin-right: 0; /* No margin after the last element */
         }
         .weight-predict-title {
         margin-right: 5px; /* Space between weight and date */
         position: relative; /* Relative positioning to allow for adjustments */
         top: var(--weight-title-top, 0px); /* Control vertical positioning */
         left: var(--weight-title-left, 0px); /* Control horizontal positioning */
         color: var(--weight-text-color, #007BFF); /* Text color for weight text */
         }
         .weight-predict-chart-slider {
         position: relative; /* Relative positioning to allow for adjustments */
         top: var(--chart-slider-top, 0px); /* Control vertical positioning */
         left: var(--chart-slider-left, 0px); /* Control horizontal positioning */
         color: var(--chart-slider-color, #FF6347); /* Text color for chart slider */
         }
         .weight-predict-chart__svg-wrapper {
         display: block;
         margin: 0 auto;
         max-width: 1200px;
         width: 100%;
         }
         .price-list-item kbd {
         background-color: transparent;
         color: #333;
         font-weight: bold;
         padding: 0;
         font-size: 12px;
         }
         .logo-container {
         position: relative;
         text-align: center;
         }
         .logo-img {
         position: relative;
         top: 15px;
         left: 765px;
         }
         .money_back_sec {
         background-color: #ffffff;
         padding: 15px 30px;
         border-radius: 10px;
         box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
         max-width: 600px;
         margin: 0 auto;
         font-family: 'Arial', sans-serif;
         text-align: center;
         position: relative;
         overflow: hidden;
         }
         .money_back_sec h6 {
         font-size: 1.25rem;
         margin-bottom: 10px;
         color: #333333;
         }
         .money_back_sec p {
         font-size: 1rem;
         color: #666666;
         }
         .money_back_sec span {
         color: #56a97a;
         }
         .money_back_sec::before {
         content: '';
         position: absolute;
         top: 0;
         left: 0;
         right: 0;
         height: 4px;
         background: linear-gradient(to right, #56a97a, #56a97a 20%, #ffffff 20%);
         animation: loading 8s linear infinite;
         }
         @keyframes loading {
         from { left: -100%; }
         to { left: 100%; }
         }
         }
         /* This style applies to all devices */
         .countdown-container {
         background-color: #f8f9fa;
         color: #212529;
         padding: 8px 20px;
         font-size: 16px;
         font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
         text-align: center;
         width: 100%;
         position: fixed;
         bottom: 0;
         left: 0;
         border-top: 1px solid #dee2e6;
         box-shadow: 0 -3px 5px rgba(0, 0, 0, 0.05);
         border-radius: 5px 5px 0 0;
         z-index: 1000;
         }
         @media (max-width: 767px) {
         .countdown-container {
         font-size: 14px; /* Adjusted for smaller screens */
         padding: 8px 15px; /* Smaller padding */
         }
         }
      </style>
      <style>
         /* Mobile Styles for Logo */
         @media (max-width: 767px) {
         .logo-img {
         position: relative;
         top: var(--logo-mobile-top, 30px); /* Mobile vertical control */
         left: var(--logo-mobile-left, 126px); /* Mobile horizontal control */
         transform: translate(var(--logo-mobile-horizontal, 0%), var(--logo-mobile-vertical, 0%));
         }
         /* Mobile Styles for Countdown Timers */
         .countdown-container {
         font-size: 14px; /* Adjusted for smaller screens */
         padding: 8px 15px; /* Smaller padding for mobile */
         /* Mobile positioning controls */
         position: fixed;
         bottom: var(--countdown-mobile-bottom, 0px); /* Vertical positioning */
         left: var(--countdown-mobile-left, 0px); /* Horizontal positioning */
         }
         }
         /* Mobile Styles for Reviews */
         @media (max-width: 767px) {
         .css-ho521d {
         width: 100%; /* Use full width for a wider appearance */
         margin: 5px auto; /* Keep them centered with a little vertical spacing */
         padding: 5px 15px; /* Reduce vertical padding to make it flatter, increase horizontal for better text alignment */
         position: relative; /* Enables precise positional adjustments */
         top: var(--reviews-mobile-top, 0px); /* Allows vertical adjustments */
         left: var(--reviews-mobile-left, -15px); /* Allows horizontal adjustments */
         box-shadow: none; /* Removes any shadow for a flatter design */
         border-radius: 5px; /* Mildly rounded corners for a softer look */
         }
         /* Mobile Styles for Weight Predict Title */
         .weight-predict-title {
         position: relative; /* Enables offset positioning */
         top: var(--weight-predict-mobile-top, 18px); /* Mobile vertical control */
         left: var(--weight-predict-mobile-left, 35px); /* Mobile horizontal control */
         transform: translate(var(--weight-predict-mobile-horizontal, 0%), var(--weight-predict-mobile-vertical, 0%));
         }
         .weight-predict-subtitle {
         position: relative; /* Enables positioning adjustments */
         top: 25px; /* Adjust vertical position */
         left: 70px; /* Adjust horizontal position */
         }
         .price-list-item kbd {
         background-color: transparent; /* Remove any background */
         color: #333; /* Text color */
         font-weight: bold; /* Bold text */
         padding: 0; /* No padding */
         font-size: 14px; /* Font size for mobile */
         }
         .money_back_sec {
         background-color: #ffffff; /* Set background to white */
         color: #212529; /* Dark grey text for contrast */
         padding: 8px 15px; /* Reduced padding for compactness */
         font-size: 14px; /* Font size for readability */
         font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; /* Modern font */
         text-align: center; /* Center text alignment */
         border-radius: 12px; /* More curved corners for an appealing look */
         box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15); /* Subtle shadow for depth */
         max-width: 600px; /* Ensure a reasonable max-width */
         margin: 10px auto; /* Center horizontally and add vertical margin */
         position: relative; /* Position relative for layout */
         }
         .money_back_sec h6 {
         margin-bottom: 5px; /* Reduced margin for compact spacing */
         }
         .money_back_sec p {
         margin-bottom: 5px; /* Reduced margin for compact spacing */
         font-weight: bold; /* Make text bold */
         color: #333333; /* Darker color for better visibility */
         }
         .money_back_sec span {
         color: #d9534f; /* Highlight the time in a noticeable color */
         font-weight: bold; /* Ensure the time is bold */
         }
         /* Style for the bottom countdown timer */
         .countdown-container {
         background-color: #ffffff; /* Set background to white */
         color: #212529; /* Dark grey text for contrast */
         padding: 5px 10px; /* Smaller padding for compactness */
         font-size: 14px; /* Adjust font size for smaller screens */
         font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; /* Modern font */
         text-align: center; /* Center text alignment */
         width: 100%; /* Full width to align with the container */
         position: fixed; /* Fixed position to stay visible */
         bottom: 0; /* At the bottom of the viewport */
         left: 0; /* Starting from the left edge */
         border-top: 1px solid #dee2e6; /* Thinner top border */
         box-shadow: 0 -1px 3px rgba(0, 0, 0, 0.05); /* Subtle shadow for depth */
         border-radius: 10px 10px 0 0; /* Rounded corners at the top */
         z-index: 1000; /* Ensure it stays on top of other content */
         }
         }
      </style>
      <style>
         /* Ensures high specificity to override existing styles */
         .paywall-diets-vs-fasting .paywall-diets-vs-fasting-cols .paywall-diets-vs-fasting-col {
         padding: 20px; /* Adequate padding */
         box-shadow: none; /* Remove any shadow that might be causing borders */
         border: none; /* Remove borders */
         color: #000; /* Ensures text is black */
         background-clip: padding-box; /* Prevents background from bleeding into the border area */
         }
         /* Specific background and text styling for each column */
         .paywall-diets-vs-fasting-cols .paywall-diets-vs-fasting-col:first-child {
         background-color: #F2F5F3; /* Light gray for the left side */
         }
         .paywall-diets-vs-fasting-cols .paywall-diets-vs-fasting-col:last-child {
         background-color: #BAF0D9; /* Soft green for WalkSlim plan */
         }
         /* Targeting the subtitles specifically */
         .paywall-diets-vs-fasting-subtitle {
         text-align: center;
         font-weight: bold;
         color: black; /* Ensuring text color is black */
         }
         .paywall-diets-vs-fasting-list {
         list-style: none;
         padding-left: 0;
         }
         /* Ensures text in list items is black */
         .paywall-diets-vs-fasting-list li {
         color: black; /* Black text for list items */
         }
         /* Responsive adjustments for mobile view */
         @media (max-width: 767px) {
         .mobile-side-by-side .paywall-diets-vs-fasting-col {
         flex: 0 0 50%; /* Columns take up half the width each */
         max-width: 50%;
         }
         }
      </style>
      <style>
         .paywall-title {
         padding-top: var(--paywall-title-padding-top, 20px); /* Customizable top padding */
         margin-bottom: 20px; /* Retained from previous adjustment */
         text-align: center; /* Ensures the title is centered */
         }
         .paywall-title > div {
         font-weight: bold;
         font-size: 24px; /* Size of the text */
         line-height: 1.5; /* Spacing between lines */
         position: relative; /* Allows for relative positioning */
         top: var(--paywall-title-top, 0px); /* Customizable vertical offset */
         }
         .text-success {
         color: #28a745; /* Standard Bootstrap success color */
         }
      </style>
      <style>
         /* Adjusting text positioning and font size without impacting other elements */
         .weight-predict-chart__top-value {
         position: relative;
         left: var(--top-value-x, -158px);
         top: var(--top-value-y, 90px);
         font-size: var(--top-value-font-size, 13px); /* Default font size set to 13px */
         }
         .weight-predict-chart__bottom-left-value {
         position: relative;
         left: var(--bottom-left-value-x, -178px);
         top: var(--bottom-left-value-y, 225px);
         font-size: var(--bottom-left-font-size, 13px); /* Default font size set to 13px */
         }
         .weight-predict-chart__bottom-right-value {
         position: relative;
         left: var(--bottom-right-value-x, 190px);
         top: var(--bottom-right-value-y, 205px);
         font-size: var(--bottom-right-font-size, 13px); /* Default font size set to 13px */
         }
      </style>
      <style>
         /* Apply new font and bold style */
         .weight-predict-subtitle,
         .weight-predict-title-content div {
         font-family: 'Arial', sans-serif; /* Use a modern sans-serif font */
         font-weight: bold; /* Make text bold */
         font-size: 28px; /* Increase font size for better readability */
         }
         .weight-predict-title-content {
         display: flex;
         justify-content: center;
         align-items: center;
         font-size: 3.5rem; /* General font size for title content */
         flex-wrap: wrap;
         }
         .goal-weight-display {
         color: #198754; /* Green color for the goal weight */
         }
         .goal-date {
         font-weight: bold;
         color: #007BFF; /* Blue color for the goal date */
         }
         /*today changes 06-08-24*/
         p.app-text.fw-bold.p4.plan-name {
         font-size: 17px;
         margin-right: 20px;
         }
         p.app-text.p4.plan-price {
         font-size: 14px;
         }
         span.target_price {
         font-size: 14px;
         }
         /*today changes 06-08-24*/
      </style>
      <style>
         :root {
         /* Default positions which you can adjust as needed */
         --app-store-x: 30px;  /* Horizontal position adjustment */
         --app-store-y: -9px;  /* Vertical position adjustment */
         }
         .app-store-img {
         transition: transform 0.3s ease-in-out; /* Smooth transition for movement */
         }
      </style>
      <style>
         .logo-img-wrap {
         width: 180px;  /* Adjust the width as needed */
         height: auto;  /* Maintain the aspect ratio */
         display: block;  /* Ensures the logo is centered in the div */
         margin-left: auto;  /* Center align the image horizontally */
         margin-right: auto;
         margin-top: -50px;  /* Move the logo up by 50px */
         padding-bottom: 30px;  /* Adds space below the logo */
         }
         /* Mobile-specific styles */
         @media (max-width: 768px) {
         .logo-img-wrap {
         display: none; /* Hide the desktop logo on mobile devices */
         }
         }
      </style>
      <style>
         /* Desktop styles */
         .save-label {
         /* These styles will only apply to non-mobile devices (larger than 768px) */
         color: red; /* Text color remains red on desktop */
         position: relative; /* Positioning is relative */
         left: var(--move-x, 223px); /* Horizontally positioned using a CSS variable */
         top: var(--move-y, -15px); /* Vertically positioned using a CSS variable */
         font-size: var(--font-size, 12px); /* Font size controlled by a CSS variable */
         font-weight: bold; /* Text is bold */
         }
         /* Mobile-only styles */
         @media (max-width: 768px) {
         .save-label {
         color: red; /* Text color */
         position: relative; /* Enables positioning relative to its normal position */
         left: 160px; /* Overrides horizontal position for mobile */
         top: -10px; /* Overrides vertical position for mobile */
         font-size: 13px; /* Increases font size for better readability on mobile */
         font-weight: bold; /* Keeps text bold */
         }
         }
      </style>
      <style>
         /* Default hidden state for mobile logo */
         .mobile-logo-wrapper {
         display: none; /* Hidden by default */
         }
         /* Mobile-specific styles */
         @media (max-width: 768px) {
         .mobile-logo-wrapper {
         display: block; /* Show the mobile logo on mobile devices */
         text-align: center;
         margin-bottom: 4px; /* Adjust bottom margin */
         }
         .mobile-logo-adjusted {
         width: 180px; /* Mobile-specific width */
         height: auto; /* Maintain aspect ratio */
         margin: 0 auto 10px; /* Center the logo horizontally and adjust spacing */
         position: relative; /* Allows for top and left positioning */
         top: var(--mobile-logo-top, 20px); /* Adjustable vertical position */
         left: var(--mobile-logo-left, 0px); /* Adjustable horizontal position */
         }
         .desktop-logo-adjusted {
         display: none; /* Hide desktop logo on mobile devices */
         }
         }
      </style>
<style>
/* Control the position of the total section */
.total-custom {
    position: relative;
}

/* Control the position of the "Total" label */
.total-custom .total-label {
    position: absolute;
    top: 800px; /* Adjust the top position as needed */
    left: 10px; /* Adjust the left position as needed */
}

/* Control the position of the price section */
.total-custom .total-price {
    position: absolute;
    top: 800px; /* Adjust the top position as needed */
    left: 150px; /* Adjust the left position as needed */
}
</style>

<style>
   /* Target the Card Detail heading */
   .custom-form-container h6 {
       margin-bottom: 0 !important; /* Remove bottom margin */
       padding-bottom: 0 !important; /* Remove bottom padding */
       line-height: 1.2 !important; /* Adjust line-height for tighter spacing */
   }

   /* Ensure the card number element is closely aligned */
   .custom-form-container #card-number-element {
       margin-top: -60px !important; /* Move the element up by 10px */
   }

   /* Optional: Remove any padding or margin from parent containers */
   .custom-form-container .form-control {
       margin-top: 0 !important;
       padding-top: 0 !important;
   }

   /* If there's additional spacing from a wrapper div, remove it */
   .custom-form-container div {
       margin-top: 0 !important;
       padding-top: 0 !important;
   }
</style>

<style>
   /* General form control adjustments for better text alignment */
   .custom-form-container .form-control {
       padding: 8px 12px !important; /* Adjust padding to ensure text is centered */
       height: auto !important; /* Let the height adjust based on content */
       line-height: normal !important; /* Use normal line-height */
       box-sizing: border-box !important; /* Ensure padding is included in height calculation */
   }

   /* Specifically target the card elements */
   .custom-form-container #card-number-element, 
   .custom-form-container #card-expiry-element, 
   .custom-form-container #card-cvc-element {
       padding: 8px 12px !important; /* Apply consistent padding */
       height: 40px !important; /* Set a consistent height */
       line-height: 1.5 !important; /* Adjust line-height */
       font-size: 16px !important; /* Set a consistent font size */
   }

   /* Ensure placeholders are also vertically aligned */
   .custom-form-container .form-control::placeholder {
       line-height: normal !important; /* Normal line-height for placeholders */
       font-size: 16px !important; /* Ensure placeholder text is also correctly sized */
   }
</style>

<style>
.d-flex {
    position: relative;
    top: 10px;  /* Adjust the value as needed */
    left: 5px; /* Adjust the value as needed */
}

.gap-3 {
    position: relative;
    top: 10px;  /* Adjust the value as needed */
    left: 5px; /* Adjust the value as needed */
}

.paywall-user-research-badge {
    position: relative;
    top: 10px;  /* Adjust the value as needed */
    left: 5px; /* Adjust the value as needed */
}

.mb-3 {
    position: relative;
    top: 10px;  /* Adjust the value as needed */
    left: 5px; /* Adjust the value as needed */
}

.fa-thumbs-up {
    position: relative;
    top: 10px;  /* Adjust the value as needed */
    left: 5px; /* Adjust the value as needed */
}

.fs-3 {
    position: relative;
    top: 10px;  /* Adjust the value as needed */
    left: 5px; /* Adjust the value as needed */
}



.user-research-badge {
    position: relative;
    top: 10px;  /* Adjust the value as needed */
    left: 5px; /* Adjust the value as needed */
}


.user-research-badge-note {
    position: relative;
    top: 10px;  /* Adjust the value as needed */
    left: 5px; /* Adjust the value as needed */
}
</style>

<style>
  .paywall-diets-vs-fasting-list-item {
    position: relative;
    padding-left: 20px;
    line-height: 1.5;
    text-align: left;
    font-size: 14px;
}

   .paywall-diets-vs-fasting-list-item i {
       position: absolute;
       left: 0;
       top: 50%;
       transform: translateY(-50%); /* Aligns the checkmark vertically */
   }
</style>
      <!-- Event snippet for Begin_Checkout conversion page -->
<script>
  gtag('event', 'Begin_Checkout', {'send_to': 'AW-11430960136/NNnICNS21YMZEIi42soq'});
</script>

      <!-- Meta Pixel Code -->
          <!-- Facebook Pixel Code -->
    <script>
        ! function(f, b, e, v, n, t, s) {
            if (f.fbq) return;
            n = f.fbq = function() {
                n.callMethod ?
                    n.callMethod.apply(n, arguments) : n.queue.push(arguments)
            };
            if (!f._fbq) f._fbq = n;
            n.push = n;
            n.loaded = !0;
            n.version = '2.0';
            n.queue = [];
            t = b.createElement(e);
            t.async = !0;
            t.src = v;
            s = b.getElementsByTagName(e)[0];
            s.parentNode.insertBefore(t, s)
        }(window, document, 'script',
            'https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', '684008796973268'); //
        fbq('track', 'InitiateCheckout'); //
    </script>
    <noscript><img height="1" width="1" style="display:none" src="https://www.facebook.com/tr?id=684008796973268&ev=InitiateCheckout&noscript=1" /></noscript>
    <!-- End Facebook Pixel Code -->
      <!-- Taboola Pixel Code -->
      <script>
         _tfa.push({notify: 'event', name: 'start_checkout_try_WS', id: 1421304});
      </script>
      <!-- End of Taboola Pixel Code -->
      <script data-obct type = "text/javascript">
         /** DO NOT MODIFY THIS CODE**/
         !function(_window, _document) {
           var OB_ADV_ID = '000ebcc43e9621610670aa93e2a72855a3';
           if (_window.obApi) {
             var toArray = function(object) {
               return Object.prototype.toString.call(object) === '[object Array]' ? object : [object];
             };
             _window.obApi.marketerId = toArray(_window.obApi.marketerId).concat(toArray(OB_ADV_ID));
             return;
           }
           var api = _window.obApi = function() {
             api.dispatch ? api.dispatch.apply(api, arguments) : api.queue.push(arguments);
           };
           api.version = '1.1';
           api.loaded = true;
           api.marketerId = OB_ADV_ID;
           api.queue = [];
           var tag = _document.createElement('script');
           tag.async = true;
           tag.src = '//amplify.outbrain.com/cp/obtp.js';
           tag.type = 'text/javascript';
           var script = _document.getElementsByTagName('script')[0];
           script.parentNode.insertBefore(tag, script);
         }(window, document);
         
         obApi('track', 'Checkout_ Initiated');
      </script>
<!-- Pinterest Initiate Checkout Conversion Tag -->
<script>
!function(e){if(!window.pintrk){window.pintrk = function () {
window.pintrk.queue.push(Array.prototype.slice.call(arguments))};var
  n=window.pintrk;n.queue=[],n.version="3.0";var
  t=document.createElement("script");t.async=!0,t.src=e;var
  r=document.getElementsByTagName("script")[0];
  r.parentNode.insertBefore(t,r)}}("https://s.pinimg.com/ct/core.js");
pintrk('load', '2613547888641', {em: '<user_email_address>'});
pintrk('track', 'checkout');
</script>
<noscript>
<img height="1" width="1" style="display:none;" alt=""
  src="https://ct.pinterest.com/v3/?event=checkout&tid=2613547888641&pd[em]=<hashed_email_address>&noscript=1" />
</noscript>
<!-- end Pinterest Initiate Checkout Conversion Tag -->
      <!-- Mobile Logo -->
      <div class="mobile-logo-wrapper">
         <img src="./assets/image/logo.png" alt="Mobile logo" class="mobile-logo-adjusted img-fluid">
      </div>
      </head>
      <body>
         </head>
         <body>
            <div class="count_bar">
            </div>
            <section class="plan-cehckout-sec">
               <div class="container">
                  <div class="container-fluid plan-cehckout-inner pt-4">
                     <!--<div style="text-align: center;" >-->
                     <!--    <img src="./assets/image/logo.png" alt="logo" class="logo-img">-->
                     <!--</div>-->
                     <div class="text-center mb-4">
                        <img src="./assets/image/logo.png" alt="logo" class="logo-img-wrap img-fluid">
                     </div>
                     <div class="weight-predict-block">
                        <div class="weight-predict-inner">
                           <div class="weight-predict-subtitle">You can reach your goal of</div>
                           <div class="weight-predict-title">
                              <div class="weight-predict-title-content">
                                 <div class="goal-weight-display">80 lbs</div>
                                 <!-- Dynamic weight placeholder -->
                                 <div> by </div>
                                 <div class="goal-date">December 11</div>
                              </div>
                           </div>
                           <div class="weight-predict-chart__chart-wrapper">
                              <div data-weight-chart="weight-predict" class="weight-predict-chart__chart">
                                 <div class="weight-predict-chart__grid-item weight-predict-chart__grid-item-1"></div>
                                 <div class="weight-predict-chart__grid-item weight-predict-chart__grid-item-2"></div>
                                 <div class="weight-predict-chart__grid-item weight-predict-chart__grid-item-3"></div>
                                 <div class="weight-predict-chart__top-value weight-predict-chart__text-value"> 122 lbs </div>
                                 <div class="weight-predict-chart__bottom-left-value weight-predict-chart__text-value"> NOW
                                 </div>
                                 <div class="weight-predict-chart__bottom-right-value weight-predict-chart__text-value"> DEC
                                 </div>
                                 <div class="weight-predict-chart__svg-wrapper">
                                    <svg preserveAspectRatio="none" class="weight-predict-chart__svg-chart" viewBox="0 0 350 180">
                                       <defs>
                                          <linearGradient id="left-gradient" x1="0%" x2="0" y1="0%" y2="100%">
                                             <stop offset="0%" stop-color="rgba(125, 139, 247, 0.3)"></stop>
                                             <stop offset="100%" stop-color="rgba(125, 139, 247, 0)"></stop>
                                          </linearGradient>
                                          <linearGradient id="right-gradient" x1="0%" x2="0" y1="0%" y2="100%">
                                             <stop offset="0%" stop-color="rgba(123, 201, 71, 0.2)"></stop>
                                             <stop offset="100%" stop-color="rgba(123, 201, 71, 0)"></stop>
                                          </linearGradient>
                                       </defs>
                                       <rect x="10" y="30" width="1" height="127" fill="#D3D3D3" />
                                       <rect x="101" y="30" width="1" height="127" fill="#D3D3D3" />
                                       <rect x="192" y="30" width="1" height="127" fill="#D3D3D3" />
                                       <rect x="273" y="30" width="1" height="127" fill="#D3D3D3" />
                                       <rect x="348" y="30" width="1" height="127" fill="#D3D3D3" />
                                       <path
                                          d="M11,158C38.16,158,65.32,158,92.48,158C119.64,158,146.8,158,173.96,158C197.24,158,220.52,158,243.8,158L243.8,107.04C220.52,105.44,197.24,103.84,173.96,97.44C146.8,89.973,119.64,64.373,92.48,55.84C65.32,47.307,38.16,45.173,11,43.04Z"
                                          fill="url(#left-gradient)" style="opacity: 1;"></path>
                                       <path d="M243.8,158L350,158L350,107.04L243.8,107.04Z" fill="url(#right-gradient)" style="opacity: 1;"></path>
                                       <path
                                          d="M11,43.04C38.16,45.173,65.32,47.307,92.48,55.84C119.64,64.373,146.8,89.973,173.96,97.44C197.24,103.84,220.52,105.44,243.8,107.04"
                                          stroke="#7D8BF7" stroke-width="3" fill="none"
                                          stroke-dasharray="245.06008911132812 245.06008911132812" stroke-dashoffset="0"></path>
                                       <path d="M243.8,107.04L350,107.04" stroke="#56A97A" stroke-width="3" fill="none"
                                          stroke-dasharray="106.2 106.2" stroke-dashoffset="0"></path>
                                       <circle cx="11" cy="43.04" r="4" fill="#7D8BF7"></circle>
                                       <circle cx="243.8" cy="107.04" r="7" fill="#7D8BF7" stroke="#fff" stroke-width="2"
                                          style="transform-origin: 243.8px 107.04px; transform: scale(1, 1);"></circle>
                                    </svg>
                                 </div>
                                 <div class="weight-predict-chart__maintain-weight">
                                    Maintain weight
                                 </div>
                                 <div data-bounds="tooltip" class="weight-predict-chart__goal-label">
                                    <div class="weight-predict-chart__goal-label-text">
                                       Goal <br><span id="goal-weight">80 lbs</span>
                                    </div>
                                    <div class="weight-predict-chart__goal-label-chevron"></div>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                     <div class="weight-predict-chart-note text-start">This
                        chart is for illustrative purposes only
                     </div>
                     <!--</div>-->
                     <?php include ('./assets/includes/script.php'); ?>
                     <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
                     <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            // Pulling from localStorage without default values
                            var currentWeight = parseFloat(localStorage.getItem('current_weight'));
                            var targetWeight = parseFloat(localStorage.getItem('target_weight'));
                        
                            if (isNaN(currentWeight) || isNaN(targetWeight)) {
                                console.error("Current weight or target weight not found in localStorage.");
                            } else {
                                // Find elements to display weights
                                var topValueElement = document.querySelector('.weight-predict-chart__top-value');
                                var goalWeightElement = document.getElementById('goal-weight'); // Selecting the new span
                        
                                // Update elements with current and target weights
                                if (topValueElement) {
                                    topValueElement.textContent = currentWeight + " lbs"; // Update the top weight value
                                }
                        
                                if (goalWeightElement) {
                                    goalWeightElement.textContent = `${targetWeight} lbs`; // Update the goal weight value
                                }
                            }
                        });
                     </script>
                     <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            var targetWeight = parseFloat(localStorage.getItem('target_weight')); // Retrieve the target weight from localStorage
                            var goalDate = localStorage.getItem('goal_date') || 'December 11'; // Retrieve or default to December 11
                        
                            // Check and update the target weight display
                            var weightDisplay = document.querySelector('.goal-weight-display');
                            if (weightDisplay) {
                                if (isNaN(targetWeight)) {
                                    console.error("Target weight not found in localStorage.");
                                    weightDisplay.textContent = "Loading..."; // Placeholder if data isn't available
                                } else {
                                    weightDisplay.textContent = `${targetWeight} lbs`; // Update with actual data
                                }
                            }
                        
                            // Update the goal date display
                            var dateDisplay = document.querySelector('.goal-date');
                            if (dateDisplay) {
                                dateDisplay.textContent = goalDate;
                            }
                        });
                     </script>
                     <h2 class="paywall-title">
                        Grab your Personal Plan<br>before it's gone!
                     </h2>
                     <div class="money_back_sec">
                        <h6 id="headline" class="fw-bold">Quick! Your Customized Plan is On Hold!</h6>
                        <p id="message">Your unique plan will be reserved for the next <span id="time" class="fw-bold">04:24</span> minutes only.</p>
                     </div>
                     <div class="countdown-container">
                        <p class="mb-0">Your Personalized Plan Is On Hold! Confirm In <span id="bottom_time">04:24</span>
                     </div>
                     <!-- Modal -->
                     <div class="modal fade" id="priceModal" tabindex="-1" role="dialog" aria-labelledby="priceModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-sm" role="document">
                           <div class="modal-content rounded-4 shadow-lg">
                              <div class="modal-body p-4">
                                 <h3 class="text-center mb-3">Try MyFastingMentor for 7 days!</h3>
                                 <p class="text-center">Money shouldn't stand in the way of your <strong>weight loss</strong> and <strong>well-being goals</strong>. So choose an amount that you think is reasonable to try us out.</p>
                                 <div class="alert alert-success text-center rounded-3" role="alert">
                                    It costs us $18.37 to cover our expenses for the trial, but please choose an amount you're comfortable with.
                                 </div>
                                 <h5 class="text-center mb-3">Choose a price for your 7-day trial</h5>
                                 <div class="d-flex justify-content-around mb-3">
                                    <div class="plan-price p-3 rounded-3 shadow-sm" data-price="0.50">$0.50</div>
                                    <div class="plan-price p-3 rounded-3 shadow-sm" data-price="3">$3</div>
                                    <div class="plan-price p-3 rounded-3 shadow-sm" data-price="10">$10</div>
                                    <div class="plan-price p-3 rounded-3 shadow-sm selected bg-success text-white" data-price="18.37">$18.37</div>
                                 </div>
                                                                  <div class="d-flex align-items-center justify-content-start mb-3 position-relative">
    <p class="mb-0 text-muted smaller-text">This option will help us support those who need to select the lowest trial prices!</p>
    <img src="https://imagedelivery.net/Ae8sF6FuGEmwqSo_o8S3HQ/783d114f-55ee-4fe9-4d07-76dfdce77000/public" alt="Arrow pointing to $18.37" class="position-absolute arrow-img" style="width: 87px; height: auto; top: -12px; left: 375px;">
</div>
                                 <button  id="seePlanButton" class="btn btn-success btn-lg w-100 rounded-pill ">See My Plan</button>
                                 <div class="alert alert-warning text-center rounded-3 mt-3" role="alert">
                                    7-day trial offer expires in <span id="offer-timer">09:04</span>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                     <script>
    $(document).ready(function() {
        // Show the modal on page load
        $('#priceModal').modal({
            backdrop: 'static',
            keyboard: false,
            show: true
        });

        // Disable scrolling when the modal is shown
        $('#priceModal').on('shown.bs.modal', function () {
            $('body').css({
                overflow: 'hidden',
                position: 'fixed',
                width: '100%'
            });
        });

        // Enable scrolling when the modal is hidden
        $('#priceModal').on('hidden.bs.modal', function () {
            $('body').css({
                overflow: '',
                position: '',
                width: ''
            });
        });

        // Handle plan selection
        $('.plan-price').click(function() {
            $('.plan-price').removeClass('selected bg-success text-white');
            $(this).addClass('selected bg-success text-white');
            $('#seePlanButton').removeClass('disabled');
        });

        // Handle "See My Plan" button click
        $('#seePlanButton').click(function() {
            if (!$(this).hasClass('disabled')) {
                let selectedPlan = $('.plan-price.selected').data('price');
                $('#selected-price').text('$' + selectedPlan);
                $('#priceModal').modal('hide');
                $('#payment-container').show();
            }
        });

        // Timer for the offer expiration
        let timer = 9 * 60 + 4;
        setInterval(function() {
            if (timer <= 0) return;
            timer--;
            let minutes = Math.floor(timer / 60);
            let seconds = timer % 60;
            $('#offer-timer').text(`${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`);
        }, 1000);
    });
</script>

<style>
    /* Default styles for desktop */
    .arrow-img {
        width: 85px;
        height: auto;
        top: -10px;
        left: 345px;
    }
    /* Styles for mobile */
    @media (max-width: 768px) {
        .arrow-img {
            width: 73px;
            top: 0;
            left: 91%;
            transform: translateX(-50%);
        }
    }
</style>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
                     <script>
                        $(document).ready(function() {
                            // Show the modal on page load
                            $('#priceModal').modal('show');
                        
                            // Handle plan selection
                            $('.plan-price').click(function() {
                                $('.plan-price').removeClass('selected bg-success text-white');
                                $(this).addClass('selected bg-success text-white');
                                $('#seePlanButton').removeClass('disabled');
                            });
                        
                            // Handle "See My Plan" button click
                            $('#seePlanButton').click(function() {
                                if (!$(this).hasClass('disabled')) {
                                    let selectedPlan = $('.plan-price.selected').data('price');
                                    $('#selected-price').text('$' + selectedPlan);
                                    $('#priceModal').modal('hide');
                                    $('#payment-container').show();
                                }
                            });
                        
                            // Timer for the offer expiration
                            let timer = 9 * 60 + 4;
                            setInterval(function() {
                                if (timer <= 0) return;
                                timer--;
                                let minutes = Math.floor(timer / 60);
                                let seconds = timer % 60;
                                $('#offer-timer').text(`${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`);
                            }, 1000);
                        });
                     </script>
                     
                     <style>
                        .modal-dialog.modal-sm {
                        max-width: 500px;
                        }
                        .modal-content {
                        border-radius: 20px;
                        border: none;
                        }
                        .plan-price {
                        border: 1px solid #ccc;
                        cursor: pointer;
                        text-align: center;
                        flex: 1;
                        margin: 0 5px;
                        transition: all 0.3s ease;
                        }
                        .plan-price.selected {
                        background-color: #28a745;
                        color: #fff;
                        border-color: #28a745;
                        transform: scale(1.05);
                        }
                        .plan-price:hover {
                        transform: scale(1.05);
                        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
                        }
                        #seePlanButton {
                        background-color: #6c757d;
                        border: none;
                        transition: background-color 0.3s ease;
                        }
                        #seePlanButton:not(.disabled):hover {
                        background-color: #28a745;
                        }
                        .alert {
                        margin-bottom: 20px;
                        padding: 15px;
                        font-size: 14px;
                        }
                        .alert-success {
                        background-color: #d4edda;
                        border-color: #c3e6cb;
                        color: #155724;
                        }
                        .alert-warning {
                        background-color: #fff3cd;
                        border-color: #ffeeba;
                        color: #856404;
                        }
                        #offer-timer {
                        font-weight: bold;
                        }
                        .smaller-text {
                        font-size: 12px;
                        margin-right: 10px;
                        }
                     </style>
                     
                     <style>
.arrow-img {
    width: 87px;
    height: auto;
    top: -12px;
    left: 375px; /* Original positioning for desktop */
    display: block;
}

@media (max-width: 768px) {
    .arrow-img {
        left: 1.8%; /* Move the image slightly more to the left on mobile */
        transform: translateX(-107%); /* Adjust transform slightly more to move it to the left */
        top: -6px; /* Move the image slightly down */
        width: 60px; /* Smaller width for mobile */
    }
}
</style>
                     <div class="d-flex gap-3 paywall-user-research-badge mb-3">
                        <i class="fa fa-thumbs-up fs-3 text-success"></i>
                        <div class="user-research-badge" style="text-align: left;">
                           <span>People using MyFastingMentor for 3 months lose twice as much weight as for 1 month*</span>
                           <div class="user-research-badge-note" style="font-size: smaller; color: gray;">
                              *According to MyFastingMentor user research, 2023
                           </div>
                        </div>
                     </div>
                     <a href="#payPalSection" class="btn app-button d-block text-white fw-semibold w-100 pulsing bg-success my_plan" 
   style="border-radius: 15px; padding-top: 12px; padding-bottom: 12px; margin-top: 65px; margin-bottom: 20px;">
   <span>GET MY PLAN</span>
</a>
                     <button class="btn app-button d-block text-success fw-semibold w-100 bg-transparent shadow-none">
                     <span> I have Promo code </span>
                     </button>
                     <div class="card shadow-sm border-0 rounded-16 mt-4">
                        <div class="card-body py-4">
                           <div class="g-0 justify-content-center row">
                              <div class="col-md-10 mb-4 pb-2 px-3 pt-2">
                                 <div class="app-store-header d-flex">
                                    <img src="https://assets.simple.life/static/v0.270.0/img/olive-branch-left.4f5e386b.svg"
                                       alt="">
                                    <div class="app-store-header-content text-center px-2">
                                       <div class="app-store-header-title h3 mb-1 fw-bold" style="color: #212529;">
                                          7+ Million
                                       </div>
                                       <div class="app-store-header-text fw-semibold px-2" style="color: #212529;">
                                          users started their weight loss journey with us
                                       </div>
                                    </div>
                                    <img src="https://assets.simple.life/static/v0.270.0/img/olive-branch-right.f93485b6.svg"
                                       alt="">
                                 </div>
                              </div>
                           </div>
                           <div class="col-md-10 mx-auto px-3">
                              <div class="align-items-center app-store-stores d-flex gap-3 justify-content-between p-3">
                                 <div class="app-store-rating">
                                    <div class="app-store-stars">
                                       <img src="https://assets.simple.life/static/v0.270.0/img/stores-stars.f5ebc934.svg" alt="">
                                    </div>
                                    <div class="app-store-rate text-success">
                                       <b class="fs-4">4.8</b><span> out of 5</span>
                                    </div>
                                 </div>
                                 <div class="app-store-images d-flex gap-3">
                                    <div class="align-items-center app-store-img d-flex flex-column" 
                                       style="position: relative; 
                                       left: var(--app-store-x, 20px); 
                                       top: var(--app-store-y, 20px);">
                                       <i class="fa fa-3x fa-apple"></i>
                                       <span>App Store</span>
                                    </div>
                                    <div class="align-items-center app-store-img d-flex flex-column">
                                       <img src="" alt="" class="img-fluid"
                                          width="43">
                                       <span></span>
                                    </div>
                                 </div>
                              </div>
                              <div class="app-store-footer fs-5 fw-bold mt-4 pt-2 mb-2 text-center" style="color: #212529;"> Over 351,000 5-star ratings from happy users 😍 </div>
                           </div>
                        </div>
                     </div>
                   <div class="paywall-title" style="--paywall-title-top: -10px; --paywall-title-padding-top: 35px; text-align: center; line-height: 1.2;">
    <div>
        <span style="display: block; font-weight: bold;">Lose weight</span>
        <span style="display: block; font-weight: bold; color: #198754;">without excluding foods</span>
        <span style="display: block; font-weight: bold;">you love</span>
    </div>
</div>
                     <div class="paywall-diets-vs-fasting mb-4">
                        <div class="g-0 paywall-diets-vs-fasting-cols row">
                           <div class="col-md-6 paywall-diets-vs-fasting-col py-3" style="border-radius: 10px; overflow: hidden;">
                              <div class="fw-bold paywall-diets-vs-fasting-subtitle text-center">
                                 <span>Restrictive diets</span>
                              </div>
                              <img src="https://imagedelivery.net/Ae8sF6FuGEmwqSo_o8S3HQ/d6bc8fff-056e-4f9a-6ca9-206429fe3e00/public" alt=""
                                 class="img-fluid paywall-diets-vs-fasting-img" style="border-radius: 10px;">
                              <div class="paywall-diets-vs-fasting-col-content" style="border-radius: 10px;">
                                 <ul class="list-unstyled paywall-diets-vs-fasting-list px-2 my-2">
                                    <li class="paywall-diets-vs-fasting-list-item"><i class="fa fa-close text-danger"></i> exclude
                                       foods you love
                                    </li>
                                    <li class="paywall-diets-vs-fasting-list-item mt-2"><i class="fa fa-close text-danger"></i> gain
                                       weight back
                                    </li>
                                 </ul>
                              </div>
                           </div>
                           <div class="paywall-diets-vs-fasting-col col-md-6 py-3" style="border-radius: 10px; overflow: hidden;">
                              <div class="fw-bold paywall-diets-vs-fasting-subtitle text-center">
                                 <span>MyFastingMentor plan</span>
                                 <svg data-v-2cadd1e3="" width="20" height="20" viewBox="0 0 20 20" fill="none"
                                    xmlns="http://www.w3.org/2000/svg" class="paywall-diets-vs-fasting__subtitle-icon">
                                    <path data-v-2cadd1e3=""
                                       d="M16.2662 10.7992L6.43286 18.1325C6.24953 18.2659 6.0412 18.3325 5.83286 18.3325C5.60786 18.3325 5.37453 18.2575 5.1912 18.0992C4.83286 17.7992 4.73286 17.2992 4.9412 16.8825L7.58136 11.6022C7.71988 11.3252 7.51842 10.9992 7.20868 10.9992H4.33286C3.89953 10.9992 3.5162 10.7242 3.38286 10.3159C3.24953 9.90753 3.3912 9.45753 3.73286 9.1992L13.5662 1.86587C13.9412 1.59087 14.4495 1.5992 14.8079 1.8992C15.1662 2.1992 15.2662 2.6992 15.0579 3.11587L12.4177 8.3962C12.2792 8.67324 12.4806 8.9992 12.7904 8.9992H15.6662C16.0995 8.9992 16.4829 9.2742 16.6162 9.68253C16.7495 10.0909 16.6079 10.5409 16.2662 10.7992Z"
                                       fill="#56A97A"></path>
                                 </svg>
                              </div>
                              <img src="https://imagedelivery.net/Ae8sF6FuGEmwqSo_o8S3HQ/d39b0dbb-db71-4532-56dd-bae9d8bf6200/public" alt=""
                                 class="img-fluid paywall-diets-vs-fasting-img" style="border-radius: 10px;">
                              <div class="paywall-diets-vs-fasting-col-content" style="border-radius: 10px;">
                                 <ul class="list-unstyled paywall-diets-vs-fasting-list px-2 my-2">
                                    <li class="paywall-diets-vs-fasting-list-item"><i class="fa fa-check text-success"></i> enjoy
                                       food guilt-free
                                    </li>
                                    <li class="paywall-diets-vs-fasting-list-item mt-2"><i class="fa fa-check text-success"></i> keep the
                                       weight off
                                    </li>
                                 </ul>
                              </div>
                           </div>
                        </div>
                     </div>
                     <div class="paywall-diets-vs-fasting mb-4">
                        <div class="g-0 paywall-diets-vs-fasting-cols row mobile-side-by-side">
                           <div class="col-md-6 col-6 paywall-diets-vs-fasting-col py-3" style="border-radius: 10px; overflow: hidden;">
                              <div class="fw-bold paywall-diets-vs-fasting-subtitle text-center">
                                 <span>Restrictive diets</span>
                              </div>
                              <img src="https://imagedelivery.net/Ae8sF6FuGEmwqSo_o8S3HQ/d6bc8fff-056e-4f9a-6ca9-206429fe3e00/public" alt=""
                                 class="img-fluid paywall-diets-vs-fasting-img" style="border-radius: 10px;">
                              <div class="paywall-diets-vs-fasting-col-content" style="border-radius: 10px;">
                                 <ul class="list-unstyled paywall-diets-vs-fasting-list px-2 my-2">
                                    <li class="paywall-diets-vs-fasting-list-item"><i class="fa fa-close text-danger"></i> exclude
                                       foods you love
                                    </li>
                                    <li class="paywall-diets-vs-fasting-list-item mt-2"><i class="fa fa-close text-danger"></i> gain
                                       weight back
                                    </li>
                                 </ul>
                              </div>
                           </div>
                           <div class="col-md-6 col-6 paywall-diets-vs-fasting-col py-3" style="border-radius: 10px; overflow: hidden;">
                              <div class="fw-bold paywall-diets-vs-fasting-subtitle text-center">
                                 <span>MyFastingMentor plan</span>
                                 <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"
                                    class="paywall-diets-vs-fasting__subtitle-icon">
                                    <path
                                       d="M16.2662 10.7992L6.43286 18.1325C6.24953 18.2659 6.0412 18.3325 5.83286 18.3325C5.60786 18.3325 5.37453 18.2575 5.1912 18.0992C4.83286 17.7992 4.73286 17.2992 4.9412 16.8825L7.58136 11.6022C7.71988 11.3252 7.51842 10.9992 7.20868 10.9992H4.33286C3.89953 10.9992 3.5162 10.7242 3.38286 10.3159C3.24953 9.90753 3.3912 9.45753 3.73286 9.1992L13.5662 1.86587C13.9412 1.59087 14.4495 1.5992 14.8079 1.8992C15.1662 2.1992 15.2662 2.6992 15.0579 3.11587L12.4177 8.3962C12.2792 8.67324 12.4806 8.9992 12.7904 8.9992H15.6662C16.0995 8.9992 16.4829 9.2742 16.6162 9.68253C16.7495 10.0909 16.6079 10.5409 16.2662 10.7992Z"
                                       fill="#56A97A"></path>
                                 </svg>
                              </div>
                              <img src="https://imagedelivery.net/Ae8sF6FuGEmwqSo_o8S3HQ/d39b0dbb-db71-4532-56dd-bae9d8bf6200/public" alt=""
                                 class="img-fluid paywall-diets-vs-fasting-img" style="border-radius: 10px;">
                              <div class="paywall-diets-vs-fasting-col-content" style="border-radius: 10px;">
                                 <ul class="list-unstyled paywall-diets-vs-fasting-list px-2 my-2">
                                    <li class="paywall-diets-vs-fasting-list-item"><i class="fa fa-check text-success"></i> enjoy
                                       food guilt-free
                                    </li>
                                    <li class="paywall-diets-vs-fasting-list-item mt-2"><i class="fa fa-check text-success"></i> keep the
                                       weight off
                                    </li>
                                 </ul>
                              </div>
                           </div>
                        </div>
                     </div>
                     <div class="card rounded-16 my-4 border-0 shadow-sm">
                        <div class="card-body p-4">
                           <ul class="list-unstyled list-block-list">
                              <li>You will only be charged $4.99 today for your first week (details below)</li>
                              <li>Your introductory period will last until Aug 8, 2024, 10:26 AM.</li>
                              <li>You may cancel at any time before Aug 8, 2024, 10:26 AM, and you will not be charged.</li>
                              <li>If you don’t cancel, MyFastingMentor will automatically continue your membership at the end of your introductory period and charge the membership fee (currently $29.99 USD) monthly until you cancel.</li>
                              <li>No partial refunds. You can cancel your subscription anytime on your Subscription Management page.</li>
                              <li>Your subscription will be bound by our <a href="" class="text-success">Terms</a> and <a href="" class="text-success">Privacy Policy</a></li>
                           </ul>
                        </div>
                     </div>
                     <style>
                        .card {
                        border-radius: 16px; /* Rounded corners with 16px radius */
                        margin: 16px 0; /* Top and bottom margin for spacing */
                        border: none; /* No border */
                        box-shadow: 0 4px 6px rgba(0,0,0,0.1); /* Subtle shadow for depth */
                        }
                        .card-body {
                        padding: 16px 16px 8px 16px; /* Adjusted padding */
                        text-align: left; /* Aligns text to the left */
                        color: #808396; /* New text color for all content within card-body */
                        }
                        .list-block-list {
                        padding-left: 20px; /* Padding for bullet points */
                        list-style-type: disc; /* Standard disc-style bullet points */
                        margin-bottom: 0; /* Adjusted bottom margin */
                        }
                        .list-block-list li {
                        margin-bottom: 10px; /* Bottom margin to space out the list items */
                        line-height: 1.4; /* Adjusted line height for better readability */
                        font-size: 16px; /* Suitable font size for list items */
                        }
                        .text-success {
                        color: #28a745; /* Bootstrap success color for links */
                        }
                     </style>
                     <div class="">
                        <div data-testid="checkout__section--reviews" class="css-ho521d">
        <div class="css-79elbk">
            <div class="css-wyg3yr">
                <p class="chakra-text css-1ezgnfa"><span class="chakra-text css-8ngobn">Barbara S., 52</span> I never thought a digital tool could transform my fasting journey, but myfastingmentor changed my perspective entirely. From a starting point of feeling sluggish and overweight, I've embraced intermittent fasting, guided by their intuitive daily schedules and supportive tips. I've not only shed significant weight but have gained a vibrant, healthier lifestyle. It’s been nothing short of transformative.
                </p>
                <div class="css-ei31dp">
                    <p class="chakra-text css-126p8sx">Love</p>
                    <img alt=""
                        src="https://cdn.dofasting.com/funnel/assets/images/checkout/svgDot.svg" srcset=""
                        class="chakra-image css-0">
                    <p class="chakra-text css-l1dn7o">Reply</p>
                    <img alt=""
                        src="https://cdn.dofasting.com/funnel/assets/images/checkout/svgDot.svg" srcset=""
                        class="chakra-image css-0">
                    <p class="chakra-text css-l1dn7o">Message</p>
                    <img alt=""
                        src="https://cdn.dofasting.com/funnel/assets/images/checkout/svgDot.svg" srcset=""
                        class="chakra-image css-0">
                    <p class="chakra-text css-l1dn7o">5d</p>
                </div>
            </div>
        </div>
        <div class="css-79elbk">
            <div class="css-wyg3yr">
                <p class="chakra-text css-1ezgnfa css-dli2en"><span class="chakra-text css-8ngobn">Susan L., 41</span>
                    I had lost touch with my healthier habits until MyFastingmentor reignited my commitment. Their timely reminders and motivational goals made it incredibly easy and enjoyable to stick to my fasting schedule. This app has been instrumental in getting me back to a health-focused lifestyle.
                </p>
                <div class="css-ei31dp">
                    <p class="chakra-text css-126p8sx">Love</p>
                    <img alt=""
                        src="https://cdn.dofasting.com/funnel/assets/images/checkout/svgDot.svg" srcset=""
                        class="chakra-image css-0">
                    <p class="chakra-text css-l1dn7o">Reply</p>
                    <img alt=""
                        src="https://cdn.dofasting.com/funnel/assets/images/checkout/svgDot.svg" srcset=""
                        class="chakra-image css-0">
                    <p class="chakra-text css-l1dn7o">Message</p>
                    <img alt=""
                        src="https://cdn.dofasting.com/funnel/assets/images/checkout/svgDot.svg" srcset=""
                        class="chakra-image css-0">
                    <p class="chakra-text css-l1dn7o">3d</p>
                </div>
            </div>
        </div>
        <div class="css-79elbk">
            <div class="css-wyg3yr">
                <p class="chakra-text css-1ezgnfa css-2ghkbp"><span class="chakra-text css-8ngobn">Emily T., 34</span> MyFastingMentor has been a game-changer in managing my hectic life as a busy mom. The app’s personalized fasting plans seamlessly fit into my daily routine, boosting my energy levels and reducing stress. It's an essential tool for anyone looking to enhance their well-being. I can't recommend it enough!
                </p>
                <div class="css-ei31dp">
                    <p class="chakra-text css-126p8sx">Love</p>
                    <img alt=""
                        src="https://cdn.dofasting.com/funnel/assets/images/checkout/svgDot.svg" srcset=""
                        class="chakra-image css-0">
                    <p class="chakra-text css-l1dn7o">Reply</p>
                    <img alt=""
                        src="https://cdn.dofasting.com/funnel/assets/images/checkout/svgDot.svg" srcset=""
                        class="chakra-image css-0">
                    <p class="chakra-text css-l1dn7o">Message</p>
                    <img alt=""
                        src="https://cdn.dofasting.com/funnel/assets/images/checkout/svgDot.svg" srcset=""
                        class="chakra-image css-0">
                    <p class="chakra-text css-l1dn7o">7d</p>
                </div>
            </div>
        </div>
    </div>
</div>
                     <div class="card rounded-16 my-4 border-0 shadow-sm">
                        <div class="card-body px-4">
                           <h5 class="fw-bold moneyback-title">Money-Back guarantee</h5>
                           <p>We're confident with our service quality and its results. So, if you're ready to reach your goals, give us a try! If you're not happy with your results, just let us know within 30 days after your purchase and we'll provide a full refund. You will need to demonstrate that you have followed the program.</p>
                           <div class="d-flex">
                              <p>Find more about the applicable limitations in our <a href="" class="text-success"><span>refund policy</span></a>.</p>
                              <img src="./assets/image/stamp.png" alt="" width="112">
                           </div>
                        </div>
                     </div>
                     <script>
document.addEventListener('DOMContentLoaded', function() {
    // Function to format date in a readable format
    function formatDate(date) {
        const options = { year: 'numeric', month: 'short', day: 'numeric', hour: '2-digit', minute: '2-digit' };
        return date.toLocaleDateString('en-US', options);
    }

    // Function to update the introductory period and price
    function updateIntroductoryPeriod() {
        const selectedPlan = document.querySelector('.plan-price.selected').dataset.price;
        const introDateElement = document.querySelectorAll('.list-block-list li')[1]; // Selects the second list item for date
        const cancelDateElement = document.querySelectorAll('.list-block-list li')[2]; // Selects the third list item for cancel option
        const chargeElement = document.querySelectorAll('.list-block-list li')[0]; // Selects the first list item for charge details
        
        let periodEndDate = new Date(); // Gets today's date

        // Calculate the end date based on the plan
        if (selectedPlan === '0.50') { // $0.50 plan
            periodEndDate.setDate(periodEndDate.getDate() + 7); // Example: Adds 7 days for the trial
        } else if (selectedPlan === '3') { // $3 plan
            periodEndDate.setDate(periodEndDate.getDate() + 7); // Adds 7 days for the trial
        } else if (selectedPlan === '10') { // $10 plan
            periodEndDate.setDate(periodEndDate.getDate() + 7); // Adds 7 days for the trial
        } else if (selectedPlan === '18.37') { // $18.37 plan
            periodEndDate.setDate(periodEndDate.getDate() + 7); // Adds 7 days for the trial
        }

        const formattedDate = formatDate(periodEndDate);

        // Update the UI
        chargeElement.textContent = `You will only be charged $${selectedPlan} today for your first week (details below)`;
        introDateElement.textContent = `Your introductory period will last until ${formattedDate}.`;
        cancelDateElement.textContent = `You may cancel at any time before ${formattedDate}, and you will not be charged.`;
    }

    // Get all the plan selection elements
    const planOptions = document.querySelectorAll('.plan-price');

    // Add click event listener to all plan options
    planOptions.forEach(option => {
        option.addEventListener('click', function() {
            // Remove the 'selected' class from all options
            planOptions.forEach(opt => opt.classList.remove('selected', 'bg-success', 'text-white'));
            
            // Add the 'selected' class to the clicked option
            option.classList.add('selected', 'bg-success', 'text-white');
            
            // Update the introductory period based on the new selection
            updateIntroductoryPeriod();
        });
    });

    // Initial update on page load
    updateIntroductoryPeriod();
});
                     </script>
                     <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            // Get all radio buttons in the price list
                            const priceOptions = document.querySelectorAll('.price-list-item-wrap input[type="radio"]');
                        
                            // Function to update the text based on the selected plan
                            function updatePriceText(event) {
                                const priceItem = event.target.closest('.price-list-item-wrap');
                                const selectedPlanPromoPrice = priceItem.querySelector('kbd').textContent.trim(); // Ensure we're pulling the text correctly
                                const priceTextElement = document.querySelector('.list-unstyled.list-block-list li');
                                
                                // Update the text with the new promo price
                                priceTextElement.textContent = `You will only be charged ${selectedPlanPromoPrice} today for your first week (details below)`;
                            }
                        
                            // Add event listeners to each radio button
                            priceOptions.forEach(option => {
                                option.addEventListener('change', updatePriceText);
                            });
                        
                            // Initial price update on load for the default selected option
                            const initialSelectedOption = document.querySelector('.price-list-item-wrap input[type="radio"]:checked');
                            if (initialSelectedOption) {
                                updatePriceText({target: initialSelectedOption});
                            }
                        });
                     </script>
                     <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            // Get all radio buttons within the price list
                            const priceOptions = document.querySelectorAll('.price-list-item-wrap input[type="radio"]');
                        
                            // Function to update the text based on the selected plan
                            function updatePriceText(event) {
                                const priceItem = event.target.closest('.price-list-item-wrap');
                                const selectedPlanPrice = priceItem.querySelector('kbd').textContent.trim(); // Extract the promo price from the 'kbd' element
                                const planName = priceItem.querySelector('.plan-name').textContent.trim(); // Extract the plan name
                                const billingPeriodElement = document.querySelector('#billingPeriod'); // This should be the ID of the element where the price text will be displayed
                        
                                // Define billing period based on the plan name
                                let billingPeriod = "";
                                switch (planName) {
                                    case "1-WEEK":
                                        billingPeriod = "week";
                                        break;
                                    case "1-MONTH":
                                        billingPeriod = "month";
                                        break;
                                    case "3-MONTH":
                                        billingPeriod = "first three months";
                                        break;
                                    default:
                                        billingPeriod = "month"; // Default to month if plan name does not match
                                }
                        
                                // Update the displayed text with the new price and period
                                if (billingPeriodElement) {
                                    billingPeriodElement.textContent = `You will be billed ${selectedPlanPrice} for your ${billingPeriod}.`;
                                }
                            }
                        
                            // Attach event listeners to each radio button
                            priceOptions.forEach(option => {
                                option.addEventListener('change', updatePriceText);
                            });
                        
                            // Update text initially based on the default selected plan
                            const initialSelectedOption = document.querySelector('.price-list-item-wrap input[type="radio"]:checked');
                            if (initialSelectedOption) {
                                updatePriceText({ target: initialSelectedOption });
                            }
                        });
                     </script>
                     <style>
                        .credit-card-header {
                        display: flex;
                        align-items: center;
                        justify-content: flex-start; /* Aligns content to the far left */
                        }
                        .bullet-point {
                        height: 20px; /* Adjust the height as needed */
                        width: 20px; /* Adjust the width as needed */
                        display: inline-block;
                        margin-right: 10px;
                        }
                        .credit-card-text {
                        display: inline;
                        vertical-align: middle;
                        font-size: 0.8em; /* Smaller font size for 'Credit Card' text */
                        position: relative; /* Needed for positioning adjustments */
                        left: var(--move-x, 1px); /* Horizontal position adjustment */
                        top: var(--move-y, -0.5px); /* Vertical position adjustment */
                        }
                        /* Mobile-specific styles */
                        @media (max-width: 768px) {
                        .credit-card-text {
                        font-size: 0.9em; /* Slightly larger for better readability on mobile */
                        white-space: nowrap; /* Prevents the text from wrapping onto multiple lines */
                        left: var(--move-x, 0px); /* Horizontal position adjustment for mobile */
                        top: var(--move-y, 0.9px); /* Vertical position adjustment for mobile */
                        }
                        }
                     </style>
                     <style>
                        /* Default desktop styles */
                        .pay-card-image {
                        margin-left: 160px;
                        height: 36px;
                        /* Other desktop-specific styles */
                        }
                        /* Mobile-specific styles */
                        @media (max-width: 768px) {
                        .pay-card-image {
                        margin-left: 98px !important; /* Use !important to ensure it overrides other styles */
                        height: 30px; /* Adjust the height for mobile */
                        /* Other mobile-specific adjustments */
                        }
                        }
                     </style>
                     <div style="text-align: left; position: relative; left: var(--move-x, 8px); top: var(--move-y, 0px);">
    <h2 style="font-weight: bold; font-size: 16px; margin-bottom: 10px;">PAYMENT METHOD</h2>
    <p style="font-size: 14px;">You will be billed <span id="billingPeriod">$17.99 for your first month</span> (details below)</p>
</div>
                     <div class="card overflow-hidden rounded-16 my-4 border-0 shadow-sm" id="payPalSection" style="border: none; box-shadow: none;">
                        <div class="card-header bg-white" style="border-bottom: none;">
                           <h5 class="card-title text-center fw-bold" id="checkoutModalLabel">
                              <div class="credit-card-header" style="display: flex; align-items: center;">
                                 <!-- Replaced span with img for bullet point -->
                                 <img class="bullet-point" src="https://imagedelivery.net/Ae8sF6FuGEmwqSo_o8S3HQ/f53cb021-61b3-4a7f-2084-4bdf1c6de500/public" alt="Bullet Point" />
                                 <span class="credit-card-text">Credit Card</span>
                                 <img class="pay-card-image" src="https://imagedelivery.net/Ae8sF6FuGEmwqSo_o8S3HQ/2e48cfc6-4616-41d8-30cb-bc6ca4f4dc00/public" alt="Pay Card Image" style="margin-left: 160px; height: 36px;">
                              </div>
                           </h5>
                        </div>
                        <div class="card-body">
                           <div class="credit-card-box">
                              <div class="credit-card-inner text-center">
                                 <h6></h6>
                                 <img class="img-fluid" src="">
                              </div>
                           </div>
                           <!--<div class="info-list">-->
                           <!--    <div class="info-list-item d-flex justify-content-between">-->
                           <!--       <p class="app-text fw-bold">Personalized Plan</p>-->
                           <!--       <p class="app-text  fw-bold"><span class="personalized-plan">79.99</span> USD</p>-->
                           <!--    </div>-->
                           <!--    <div class="info-list-item d-flex justify-content-between">-->
                           <!--       <p class="app-text fw-bold"><span class="discount-percent">75</span>% Introductory offer discount</p>-->
                           <!--       <p class="app-text fw-bold" style="color: red;"><span id="discount-price">60.70</span> USD</p>-->
                           <!--    </div>-->
                           <!--</div>-->
                              <!--<p class="save-label" style="color: red;">You just saved <span class="discount_plan_price">60.70</span> USD (<span class="discount-percent">75</span>% off)</p>-->
                           </div>
                           <div class="payment-form-container custom-form-container">
                              <form role="form" action="stripe/stripe_Trail_try.php" method="POST" name="cardpayment" id="payment-form"
                                 class="p-3" style="box-shadow: none;">
                                 <input type="hidden" name="email" id="email" value="<?php echo isset($_SESSION['email']) ? $_SESSION['email'] : 'test2@gmail.com'; ?>">
                                 <input type="hidden" name="selectedPlan" id="selectedPlan" value="18.37">
                                 <div class="">
                                    <div class="form-control" id="card-number-element">
                                       <div class="spinner-border" role="status">
                                          <span class="sr-only">Loading...</span>
                                       </div>
                                    </div>
                                 </div>
                                 <div class="main_expiry_cvv_section d-flex">
                                    <div class="d-flex w-100">
                                       <div class="form-control flex-fill" id="card-expiry-element">
                                       </div>
                                       <div class="form-control flex-fill" id="card-cvc-element">
                                       </div>
                                    </div>
                                 </div>
                                 <div class="outcome">
                                    <div class="error text-danger">
                                    </div>
                                 </div>
                                 <button class="btn btn-success btn-lg btn-block submit mt-4" type="button" id="payBtn">
                                    <span class="fa fa-lock"></span> <!-- Lock icon span moved before the text span -->
                                    <span class="button-text">Continue Securely</span>
                                 </button>
                                 <p class="text-center mt-2" style="font-size: 12px;">Payments are secure &amp; encrypted</p>
                              </form>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </section>
   </body>
</html>
<script src="https://js.stripe.com/v3/"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    
    $('.plan-price').on('click',function(){
        const price =   $(this).data('price');
        $('.total_plan_price').html(price)
        $('#selectedPlan').val(price)
    })
    
   let selected_plan;
     $(document).ready(function(e){
          let grand_total;
         
          // $('input[type=radio][name=price]').change(function() {
          //       if (this.checked) {
                   
          //           let price_item_element=$(this).closest('.price-list-item-wrap');
       
          //           let planPrice=price_item_element.find('.plan-price .target_price').text();
          //         selected_plan=price_item_element.find('.plan-name').text();
                 
                   
                   
          //           if(planPrice){
          //               planPrice = planPrice.replace('$', '');
          //               let discount_price=(75/100*parseFloat(planPrice)).toFixed(2)
          //               $('.personalized-plan').text(planPrice)
          //               $('#discount-price').text(discount_price)
          //               let total_price=parseFloat(planPrice)-parseFloat(discount_price)
          //               grand_total=total_price.toFixed(2)
                      
          //               $('.total_plan_price').text(total_price.toFixed(2))
          //               $('.discount_plan_price').text(discount_price)
          //           }
                   
                 
                   
          //       }
          //   });
          //   $('input[type=radio][name=price]:checked').trigger('change');
        //   kulwant Test key
    //  pk_test_51PlTNjCPqT8FlbptByFU7MoVJ3X2jU0cYW633mGUjTx80RvZ4kfAgBAU1WMkte2Wc5Sn7TSLbolNmJbnYWKEIfxA00B6abcqwC
     
    //  colton live key
    // pk_live_51OuhoIRp9feDzI9FFGmdruIwUsF0wpxV511NKRuABFpzn7ymqbPV6IeksoAO89KiiLOpNUL7xrw4fJMCogjHZp6t00yUGpvGkl
     
      var stripe = Stripe('pk_live_51OuhoIRp9feDzI9FFGmdruIwUsF0wpxV511NKRuABFpzn7ymqbPV6IeksoAO89KiiLOpNUL7xrw4fJMCogjHZp6t00yUGpvGkl');
    //   var stripe = Stripe('pk_live_51OuhoIRp9feDzI9FFGmdruIwUsF0wpxV511NKRuABFpzn7ymqbPV6IeksoAO89KiiLOpNUL7xrw4fJMCogjHZp6t00yUGpvGkl');
       
       // 
       
       
     
     
     var elements = stripe.elements();
     
     // Create individual instances for each element
     var cardNumberElement = elements.create('cardNumber', {
        placeholder: '💳 1234 1234 1234 1234', 
     style: {
       base: {
         fontWeight: 300,
         fontSize: '18px',
         '::placeholder': {
           color: '#757575',
           
         },
       },
     },
     });
     
     var cardExpiryElement = elements.create('cardExpiry', {
        
     style: {
       base: {
         fontWeight: 300,
         fontSize: '18px',
         '::placeholder': {
           color: '#757575',
         },
       },
     },
     });
     
     var cardCvcElement = elements.create('cardCvc', {
       placeholder: 'CVV', 
     style: {
       base: {
         fontWeight: 300,
         fontSize: '18px',
         '::placeholder': {
           color: '#757575',
         },
       },
     },
     });
     
     // Mount each element to its corresponding container
     cardNumberElement.mount('#card-number-element');
     cardExpiryElement.mount('#card-expiry-element');
     cardCvcElement.mount('#card-cvc-element');
     toastr.options = {
     		'closeButton': true,
     		'debug': false,
     		'newestOnTop': false,
     		'progressBar': false,
     		'positionClass': 'toast-top-right',
     		'preventDuplicates': false,
     		'showDuration': '1000',
     		'hideDuration': '1000',
     		'timeOut': '5000',
     		'extendedTimeOut': '1000',
     		'showEasing': 'swing',
     		'hideEasing': 'linear',
     		'showMethod': 'fadeIn',
     		'hideMethod': 'fadeOut',
     	}
     
     
      $("body").delegate("#payBtn", "click", function(e) {
        
         stripe.createToken(cardNumberElement).then(setOutcome);
       });
     
     function setOutcome(result) {
        
         var errorElement2 = document.querySelector('.error');
         $('.error').empty();
         
         var selectedPlan2=$('#selectedPlan').val();
         
         var email2=$('#email').val();
         
         
         let price=grand_total
       
         var holdername2 = '';
         
         if (result.token) {
             $('#payBtn').html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Loading...').prop('disabled', true);
           $.post('/stripe/stripe_Trail_try.php', {
               token: result.token,
               selectedPlan:selectedPlan2,
               email:email2,
               holdername:holdername2,
               price:price
           }, function(response) {
               var message=response.message;
             if(response.status=='success'){
                   Swal.fire({
                 icon: "success",
                 title: "success",
                 text: message,
               }).then(() => {
                 window.location.href = '/signup.php?payment_id=' + response.payment_id;
               });
     
       // Wait for toastr to close before redirecting
       // setTimeout(function() {
           
       // }, 3000);
               
     
             }else{
               //   $('#payBtn2').html('Continue').prop('disabled', false);
             
               $('.error').text(message)
             }
           }).fail(function(xhr, status, error) {
             console.error('Error:', error);
           });
         } else if (result.error) {
             $('#payBtn').html('Continue').prop('disabled', false);
           errorElement2.textContent = result.error.message;
           errorElement2.classList.add('visible');
         }
       }
       
     });
</script>
<?php include ('./assets/includes/script.php'); ?>
<script>
   // Calculate the date for a seven-day free trial
   function getTrialEndDate() {
       var currentDate = new Date();
       currentDate.setDate(currentDate.getDate() + 7);
       return currentDate.toDateString();
   }
   
   // Insert the trial end date into the HTML
   document.addEventListener("DOMContentLoaded", function() {
       var trialEndDate = getTrialEndDate();
       document.querySelectorAll(".trial-end-date").forEach(function(element) {
           element.textContent = trialEndDate;
       });
   });
</script>
<!-- Assuming the form is correctly opened somewhere above this line -->
<script>
   $(document).ready(function() {
   // Set the end time to 12 minutes from now
   let endTime = new Date().getTime() + (12 * 60 * 1000);
   let countdown = setInterval(function() {
   let now = new Date().getTime();
   let distance = endTime - now;
   let minutes = Math.floor(distance / (1000 * 60));
   let seconds = Math.floor((distance % (1000 * 60)) / 1000);
   
   // Format the countdown display
   let formattedTime = (minutes < 10 ? "0" : "") + minutes + ":" + (seconds < 10 ? "0" : "") + seconds;
   
   // Update both countdown elements
   document.getElementById("time").textContent = formattedTime;
   document.getElementById("bottom_time").textContent = formattedTime;
   
   if (distance < 0) {
       clearInterval(countdown);
       document.getElementById("time").textContent = "EXPIRED";
       document.getElementById("bottom_time").textContent = "EXPIRED";
       document.getElementById("message").textContent = "Your 7-day trial has expired!";
   }
   }, 1000);
   });
</script>
<script>
   // Calculate the date for a seven-day free trial
   function getTrialEndDate() {
     var currentDate = new Date();
     currentDate.setDate(currentDate.getDate() + 7);
     return currentDate.toDateString();
   }
   
   // Insert the trial end date into the HTML
   document.addEventListener("DOMContentLoaded", function () {
     var trialEndDate = getTrialEndDate();
     document.querySelectorAll(".trial-end-date").forEach(function (element) {
       element.textContent = trialEndDate;
     });
   });
</script>
<script>
   document.addEventListener('DOMContentLoaded', function () {
     // Pulling from localStorage without default values
     var currentWeight = parseFloat(localStorage.getItem('current_weight'));
     var targetWeight = parseFloat(localStorage.getItem('target_weight'));
   
     if (isNaN(currentWeight) || isNaN(targetWeight)) {
       console.error("Current weight or target weight not found in localStorage.");
     } else {
       // Find elements to display weights
       var topValueElement = document.querySelector('.weight-predict-chart__top-value');
       var goalLabelTextElement = document.querySelector('.weight-predict-chart__goal-label-text');
       
       var weight_predict_title_content=document.querySelector('#target-weight-top');
       
       if(weight_predict_title_content){
           weight_predict_title_content.innerText=targetWeight
       }
   
       // Update elements with current and target weights
       if (topValueElement) {
         topValueElement.textContent = currentWeight + " lbs"; // Update the top weight value
       }
   
       if (goalLabelTextElement) {
         goalLabelTextElement.innerHTML = `Goal <br> ${targetWeight} lbs`; // Update the goal weight value
       }
     }
   });
</script>
<script>
   document.addEventListener('DOMContentLoaded', function() {
       // Prices and discounts for each plan
       const plans = {
           "1-WEEK": {
               originalPrice: 9.99,
               finalPrice: 4.99,
               discountPrice: 9.99 - 4.99,
               discountPercent:50
               
           },
           "1-MONTH": {
               originalPrice: 29.99,
               finalPrice: 17.99,
               discountPrice: 29.99 - 17.99,
               discountPercent:40
               
           },
           "3-MONTH": {
               originalPrice: 59.99,
               finalPrice: 29.99,
               discountPrice: 59.99 - 29.99,
               discountPercent:50
              
           }
       };
   
       // Function to update the pricing display based on the selected plan
       function updatePricingDisplay(plan) {
        
         
            const selectedPlan = plans[plan];
          selected_plan=plan
          console.log(selected_plan)
           if (!selectedPlan) return;
   
           // Update the HTML elements with the new prices
           document.querySelector('.personalized-plan').textContent = selectedPlan.originalPrice.toFixed(2) 
           document.getElementById('discount-price').textContent = '-' + selectedPlan.discountPrice.toFixed(2)
           document.querySelector('.total_plan_price').textContent = selectedPlan.finalPrice.toFixed(2)
           document.querySelector('.discount_plan_price').textContent = '-' + selectedPlan.discountPrice.toFixed(2)
        //   document.querySelector('.discount-percent').textContent =  selectedPlan.discountPercent
                var elements = document.querySelectorAll('.discount-percent');
        
        // Loop through each element and update its text content
        elements.forEach(function(element) {
            element.textContent = selectedPlan.discountPercent // Append '%' to indicate it's a percentage
        });
           
       }
   
       // Initially update the display with the default selected plan
       const defaultPlan = document.querySelector('input[name="price"]:checked').closest('.price-list-item-wrap').querySelector('.plan-name').textContent.trim();
       updatePricingDisplay(defaultPlan);
   
       // Event listener for radio button changes
       document.querySelectorAll('input[name="price"]').forEach(radio => {
           radio.addEventListener('change', function() {
               const planName = this.closest('.price-list-item-wrap').querySelector('.plan-name').textContent.trim();
               updatePricingDisplay(planName);
           });
       });
   });
</script>
<style>
   /* Enhanced input and select styles for checkout fields */
   div#payPalSection .card-header input,
   div#payPalSection .card-header select {
      border: 1px solid #ced4da !important; /* Subtle border for input fields */
      box-shadow: 0px 2px 5px rgba(0, 0, 0, 0.1) !important; /* Soft shadow for depth */
      padding: 10px !important; /* Improved padding for better touch experience */
      border-radius: 5px !important; /* Rounded corners for a smoother look */
      transition: border-color 0.3s ease, box-shadow 0.3s ease; /* Smooth transition effects */
      width: 100%; /* Ensures full width */
      box-sizing: border-box; /* Ensures padding and border are included in width */
   }

   /* Focused state for input and select fields to enhance user trust */
   div#payPalSection .card-header input:focus,
   div#payPalSection .card-header select:focus {
      border-color: #80bdff !important; /* Highlighted border color on focus */
      box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.15) !important; /* Stronger shadow on focus */
      outline: none !important; /* Remove default outline */
   }

   /* General styles for card elements */
  /* General styles for card elements */
#card-number-element {
    width: calc(100% - 5px); /* Full-width minus padding */
    margin-bottom: 20px;
    padding: 12px 15px;
    border-radius: 4px;
    background-color: #f8f9fa;
    border: 1px solid #ced4da;
    transition: border-color 0.3s ease, box-shadow 0.3s ease;
    box-sizing: border-box;
    position: relative;
    left: 5px;
    top: 5px;
}

/* Layout adjustments */
#card-expiry-element, #card-cvc-element {
    width: calc(50% - 15px); /* Each field takes up half of the available width minus margin */
    margin-bottom: 20px;
    padding: 12px 15px;
    border-radius: 4px;
    background-color: #f8f9fa;
    border: 1px solid #ced4da;
    transition: border-color 0.3s ease, box-shadow 0.3s ease;
    box-sizing: border-box;
    display: inline-block;
    position: relative;
}

#card-expiry-element {
    margin-right: 15px; /* Space between expiry and CVV on desktop */
    left: -5px; /* Adjust horizontal positioning if needed */
    top: -8px;
}

#card-cvc-element {
    margin-left: 0px; /* Remove the margin-left to align with expiry field */
    left: -9px; /* Adjust horizontal positioning if needed */
    top: -8px;
}

/* Responsive adjustments for mobile devices */
@media (max-width: 768px) {
    #card-number-element {
        width: 95%; /* Keep the card number field width unchanged */
        margin-right: 0;
        margin-left: 0;
        margin-bottom: 15px; /* Reduce margin between fields */
        padding: 10px 12px; /* Slightly reduce padding for smaller screens */
        position: relative; /* Ensure positioning works */
        left: 10px; /* Adjusts the horizontal positioning */
        top: 8px; /* Adjusts the vertical positioning */
    }

#card-expiry-element {
    width: 42%; /* Slightly smaller width to create space for the margin */
    margin-right: 0%; /* Small space between the expiration and CVC fields */
    margin-left: 0;
    margin-bottom: 10px; /* Maintain bottom margin */
    padding: 10px 12px; /* Maintain padding */
    display: inline-block; /* Inline to stay on the same line with CVC */
    position: relative; /* Ensure positioning works */
    left: 0px; /* No horizontal shift */
    top: -7px; /* Maintain vertical alignment */
}

#card-cvc-element {
    width: 44.5% !important; /* Keep the original width */
    margin-right: 0;
    margin-left: 6%; /* Add space between the fields */
    margin-bottom: 10px; /* Maintain bottom margin */
    padding: 10px 12px; /* Maintain padding */
    display: inline-block; /* Inline to stay on the same line with Expiry */
    position: relative; /* Ensure positioning works */
    left: -18px; /* Adjust to offset the reduction in expiration width */
    top: -7px; /* Maintain vertical alignment */
}
</style>
<script>
   document.addEventListener('DOMContentLoaded', function() {
     var stripe = Stripe('your_stripe_public_key'); // Replace with your actual Stripe public key
     var elements = stripe.elements();
   
     var style = {
       base: {
         color: "#32325d",
         fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
         fontSmoothing: "antialiased",
         fontSize: "16px",
         '::placeholder': {
           color: '#aab7c4'
         },
         fontWeight: '400', // Normal weight
       },
       invalid: {
         color: "#fa755a",
         iconColor: "#fa755a"
       },
       complete: {
         color: "#00e676"
       }
     };
   
     var cardNumberElement = elements.create('cardNumber', { style: style });
     var cardExpiryElement = elements.create('cardExpiry', { style: style });
     var cardCvcElement = elements.create('cardCvc', { style: style });
   
     cardNumberElement.mount('#card-number-element');
     cardExpiryElement.mount('#card-expiry-element');
     cardCvcElement.mount('#card-cvc-element');
   });
</script>
<script>
   document.addEventListener('DOMContentLoaded', function() {
       var elements = stripe.elements();
   
       // Create an instance of the cardExpiry element
       var cardExpiryElement = elements.create('cardExpiry');
       cardExpiryElement.mount('#card-expiry-element');
   
       // Create an instance of the cardCvc element
       var cardCvcElement = elements.create('cardCvc');
       cardCvcElement.mount('#card-cvc-element');
   
       // Listen for changes in the cardExpiry element
       cardExpiryElement.on('change', function(event) {
           // Check if the expiry date has been completely filled
           if (event.complete) {
               // If complete, focus the cardCvc element
               cardCvcElement.focus();
           }
       });
   });
</script>
<script>
   document.addEventListener('DOMContentLoaded', function() {
       const countdownContainer = document.querySelector('.countdown-container');
       const desktopFooterContainer = document.querySelector('.desktop-footer-container');
       const mobileFooterContainer = document.querySelector('.mobile-footer-container');
   
       window.addEventListener('scroll', function() {
           let footerTop;
   
           // Determine which footer is visible based on screen width
           if (window.innerWidth > 768) {
               // Desktop view
               footerTop = desktopFooterContainer.getBoundingClientRect().top;
           } else {
               // Mobile view
               footerTop = mobileFooterContainer.getBoundingClientRect().top;
           }
   
           // Check if the countdown container is near the footer
           if (footerTop <= window.innerHeight) {
               countdownContainer.style.opacity = '0'; // Make countdown container disappear
           } else {
               countdownContainer.style.opacity = '1'; // Make countdown container fully visible
           }
       });
   });
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Function to update the billing period text based on the selected plan
    function updateBillingPeriod() {
        const selectedPlan = document.querySelector('.plan-price.selected').dataset.price;
        const billingPeriodElement = document.getElementById('billingPeriod');

        // Update the text content with the selected plan's price
        billingPeriodElement.textContent = `$${selectedPlan} for your first month`;
    }

    // Get all the plan selection elements
    const planOptions = document.querySelectorAll('.plan-price');

    // Add click event listener to all plan options
    planOptions.forEach(option => {
        option.addEventListener('click', function() {
            // Remove the 'selected' class from all options
            planOptions.forEach(opt => opt.classList.remove('selected', 'bg-success', 'text-white'));
            
            // Add the 'selected' class to the clicked option
            option.classList.add('selected', 'bg-success', 'text-white');
            
            // Update the billing period based on the new selection
            updateBillingPeriod();
        });
    });

    // Initial update on page load
    updateBillingPeriod();
});
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Set a flag in localStorage indicating that the user has reached the trial-offer page
    localStorage.setItem('hasVisitedTrialOffer', 'true');
});
</script>
<!-- New Footer Section -->
<style>
   /* Desktop-specific styles */
   .desktop-footer-container {
   border: 1px solid #ddd; /* Thinner border */
   border-radius: 8px;
   padding: 10px 20px; /* Adjusted padding */
   background-color: #f9f9f9;
   margin-top: -17px; /* More negative top margin to move up */
   width: auto; /* Ensures it takes only the necessary width */
   max-width: 25%; /* Limit the maximum width to a quarter of the container width */
   margin-left: auto; /* Center the container */
   margin-right: auto; /* Center the container */
   }
   .desktop-footer-text {
   color: #606060; /* Improved readability */
   font-size: 12px; /* Smaller font size */
   line-height: 1.4; /* Improved line spacing */
   margin-bottom: 5px; /* Reduced space between paragraphs */
   }
   .desktop-footer-link {
   color: #007bff; /* Standard link color */
   text-decoration: none; /* No underline */
   }
   /* Hide the desktop footer on mobile devices */
   @media (max-width: 768px) {
   .desktop-footer-container {
   display: none; /* Hide the footer on mobile devices */
   }
   }
</style>
<div class="desktop-footer-container">
   <p class="desktop-footer-text">
      You can keep your Weight loss kickstart course, even if you decide Simple isn’t for you.
   </p>
   <p class="desktop-footer-text">
      You will need an iPhone to use MyFastingMentor.
   </p>
   <p class="desktop-footer-text" style="font-weight: bold;">
      Secure checkout
   </p>
   <p class="desktop-footer-text">
      All information is encrypted and transmitted using Secure Sockets Layer protocol.
   </p>
   <p class="desktop-footer-text" style="font-weight: bold;">
      Need help?
   </p>
   <p class="desktop-footer-text">
      <a href="https://myfastingmentor.com/contact/" class="desktop-footer-link">Contact us here.</a>
   </p>
</div>
<style>
   /* Hide the mobile footer by default (desktop view) */
   .mobile-footer-container {
   display: none;
   border: 1px solid #ddd; /* Thinner border */
   border-radius: 8px;
   padding: 10px 20px; /* Adjusted padding */
   background-color: #f9f9f9;
   margin-top: 33px; /* More negative top margin to move up */
   width: auto; /* Ensures it takes only the necessary width */
   max-width: 95%; /* Limit the maximum width to a quarter of the container width */
   margin-left: auto; /* Center the container */
   margin-right: auto; /* Center the container */
   }
   .mobile-footer-text {
   color: #606060; /* Improved readability */
   font-size: 12px; /* Smaller font size */
   line-height: 1.4; /* Improved line spacing */
   margin-bottom: 5px; /* Reduced space between paragraphs */
   }
   .mobile-footer-link {
   color: #007bff; /* Standard link color */
   text-decoration: none; /* No underline */
   }
   /* Mobile specific styles to show the footer on mobile */
   @media (max-width: 768px) {
   .mobile-footer-container {
   display: block; /* Show the footer on mobile devices */
   }
   .mobile-only-footer-container {
   display: none; /* Hide the address container on mobile to avoid duplication */
   }
   }
</style>
<div class="mobile-footer-container">
   <p class="mobile-footer-text">
      You can keep your Weight loss kickstart course, even if you decide MyFastingMentor isn’t for you.
   </p>
   <p class="mobile-footer-text">
      You will need an iPhone to use MyFastingMentor.
   </p>
   <p class="mobile-footer-text" style="font-weight: bold;">
      Secure checkout
   </p>
   <p class="mobile-footer-text">
      All information is encrypted and transmitted using Secure Sockets Layer protocol.
   </p>
   <p class="mobile-footer-text" style="font-weight: bold;">
      Need help?
   </p>
   <p class="mobile-footer-text">
      <a href="https://myfastingmentor.com/contact/" class="mobile-footer-link">Contact us here.</a>
   </p>
</div>
<script src="https://js.stripe.com/v3/"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</body>
</html>