<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/binaryauthorization/v1beta1/resources.proto

namespace Google\Cloud\BinaryAuthorization\V1beta1\PkixPublicKey;

use UnexpectedValueException;

/**
 * Represents a signature algorithm and other information necessary to verify
 * signatures with a given public key.
 * This is based primarily on the public key types supported by Tink's
 * PemKeyType, which is in turn based on KMS's supported signing algorithms.
 * See https://cloud.google.com/kms/docs/algorithms. In the future, BinAuthz
 * might support additional public key types independently of Tink and/or KMS.
 *
 * Protobuf type <code>google.cloud.binaryauthorization.v1beta1.PkixPublicKey.SignatureAlgorithm</code>
 */
class SignatureAlgorithm
{
    /**
     * Not specified.
     *
     * Generated from protobuf enum <code>SIGNATURE_ALGORITHM_UNSPECIFIED = 0;</code>
     */
    const SIGNATURE_ALGORITHM_UNSPECIFIED = 0;
    /**
     * RSASSA-PSS 2048 bit key with a SHA256 digest.
     *
     * Generated from protobuf enum <code>RSA_PSS_2048_SHA256 = 1;</code>
     */
    const RSA_PSS_2048_SHA256 = 1;
    /**
     * RSASSA-PSS 3072 bit key with a SHA256 digest.
     *
     * Generated from protobuf enum <code>RSA_PSS_3072_SHA256 = 2;</code>
     */
    const RSA_PSS_3072_SHA256 = 2;
    /**
     * RSASSA-PSS 4096 bit key with a SHA256 digest.
     *
     * Generated from protobuf enum <code>RSA_PSS_4096_SHA256 = 3;</code>
     */
    const RSA_PSS_4096_SHA256 = 3;
    /**
     * RSASSA-PSS 4096 bit key with a SHA512 digest.
     *
     * Generated from protobuf enum <code>RSA_PSS_4096_SHA512 = 4;</code>
     */
    const RSA_PSS_4096_SHA512 = 4;
    /**
     * RSASSA-PKCS1-v1_5 with a 2048 bit key and a SHA256 digest.
     *
     * Generated from protobuf enum <code>RSA_SIGN_PKCS1_2048_SHA256 = 5;</code>
     */
    const RSA_SIGN_PKCS1_2048_SHA256 = 5;
    /**
     * RSASSA-PKCS1-v1_5 with a 3072 bit key and a SHA256 digest.
     *
     * Generated from protobuf enum <code>RSA_SIGN_PKCS1_3072_SHA256 = 6;</code>
     */
    const RSA_SIGN_PKCS1_3072_SHA256 = 6;
    /**
     * RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA256 digest.
     *
     * Generated from protobuf enum <code>RSA_SIGN_PKCS1_4096_SHA256 = 7;</code>
     */
    const RSA_SIGN_PKCS1_4096_SHA256 = 7;
    /**
     * RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA512 digest.
     *
     * Generated from protobuf enum <code>RSA_SIGN_PKCS1_4096_SHA512 = 8;</code>
     */
    const RSA_SIGN_PKCS1_4096_SHA512 = 8;
    /**
     * ECDSA on the NIST P-256 curve with a SHA256 digest.
     *
     * Generated from protobuf enum <code>ECDSA_P256_SHA256 = 9;</code>
     */
    const ECDSA_P256_SHA256 = 9;
    /**
     * ECDSA on the NIST P-256 curve with a SHA256 digest.
     *
     * Generated from protobuf enum <code>EC_SIGN_P256_SHA256 = 9;</code>
     */
    const EC_SIGN_P256_SHA256 = 9;
    /**
     * ECDSA on the NIST P-384 curve with a SHA384 digest.
     *
     * Generated from protobuf enum <code>ECDSA_P384_SHA384 = 10;</code>
     */
    const ECDSA_P384_SHA384 = 10;
    /**
     * ECDSA on the NIST P-384 curve with a SHA384 digest.
     *
     * Generated from protobuf enum <code>EC_SIGN_P384_SHA384 = 10;</code>
     */
    const EC_SIGN_P384_SHA384 = 10;
    /**
     * ECDSA on the NIST P-521 curve with a SHA512 digest.
     *
     * Generated from protobuf enum <code>ECDSA_P521_SHA512 = 11;</code>
     */
    const ECDSA_P521_SHA512 = 11;
    /**
     * ECDSA on the NIST P-521 curve with a SHA512 digest.
     *
     * Generated from protobuf enum <code>EC_SIGN_P521_SHA512 = 11;</code>
     */
    const EC_SIGN_P521_SHA512 = 11;

    private static $valueToName = [
        self::SIGNATURE_ALGORITHM_UNSPECIFIED => 'SIGNATURE_ALGORITHM_UNSPECIFIED',
        self::RSA_PSS_2048_SHA256 => 'RSA_PSS_2048_SHA256',
        self::RSA_PSS_3072_SHA256 => 'RSA_PSS_3072_SHA256',
        self::RSA_PSS_4096_SHA256 => 'RSA_PSS_4096_SHA256',
        self::RSA_PSS_4096_SHA512 => 'RSA_PSS_4096_SHA512',
        self::RSA_SIGN_PKCS1_2048_SHA256 => 'RSA_SIGN_PKCS1_2048_SHA256',
        self::RSA_SIGN_PKCS1_3072_SHA256 => 'RSA_SIGN_PKCS1_3072_SHA256',
        self::RSA_SIGN_PKCS1_4096_SHA256 => 'RSA_SIGN_PKCS1_4096_SHA256',
        self::RSA_SIGN_PKCS1_4096_SHA512 => 'RSA_SIGN_PKCS1_4096_SHA512',
        self::ECDSA_P256_SHA256 => 'ECDSA_P256_SHA256',
        self::EC_SIGN_P256_SHA256 => 'EC_SIGN_P256_SHA256',
        self::ECDSA_P384_SHA384 => 'ECDSA_P384_SHA384',
        self::EC_SIGN_P384_SHA384 => 'EC_SIGN_P384_SHA384',
        self::ECDSA_P521_SHA512 => 'ECDSA_P521_SHA512',
        self::EC_SIGN_P521_SHA512 => 'EC_SIGN_P521_SHA512',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SignatureAlgorithm::class, \Google\Cloud\BinaryAuthorization\V1beta1\PkixPublicKey_SignatureAlgorithm::class);

