<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/devtools/cloudbuild/v1/cloudbuild.proto

namespace Google\Cloud\Build\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration for a `WorkerPool`.
 * Cloud Build owns and maintains a pool of workers for general use and have no
 * access to a project's private network. By default, builds submitted to
 * Cloud Build will use a worker from this pool.
 * If your build needs access to resources on a private network,
 * create and use a `WorkerPool` to run your builds. Private `WorkerPool`s give
 * your builds access to any single VPC network that you
 * administer, including any on-prem resources connected to that VPC
 * network. For an overview of private pools, see
 * [Private pools
 * overview](https://cloud.google.com/build/docs/private-pools/private-pools-overview).
 *
 * Generated from protobuf message <code>google.devtools.cloudbuild.v1.WorkerPool</code>
 */
class WorkerPool extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The resource name of the `WorkerPool`, with format
     * `projects/{project}/locations/{location}/workerPools/{worker_pool}`.
     * The value of `{worker_pool}` is provided by `worker_pool_id` in
     * `CreateWorkerPool` request and the value of `{location}` is determined by
     * the endpoint accessed.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $name = '';
    /**
     * A user-specified, human-readable name for the `WorkerPool`. If provided,
     * this value must be 1-63 characters.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     */
    private $display_name = '';
    /**
     * Output only. A unique identifier for the `WorkerPool`.
     *
     * Generated from protobuf field <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $uid = '';
    /**
     * User specified annotations. See https://google.aip.dev/128#annotations
     * for more details such as format and size limitations.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 4;</code>
     */
    private $annotations;
    /**
     * Output only. Time at which the request to create the `WorkerPool` was
     * received.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $create_time = null;
    /**
     * Output only. Time at which the request to update the `WorkerPool` was
     * received.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;
    /**
     * Output only. Time at which the request to delete the `WorkerPool` was
     * received.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $delete_time = null;
    /**
     * Output only. `WorkerPool` state.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v1.WorkerPool.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state = 0;
    /**
     * Output only. Checksum computed by the server. May be sent on update and
     * delete requests to ensure that the client has an up-to-date value before
     * proceeding.
     *
     * Generated from protobuf field <code>string etag = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $etag = '';
    protected $config;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The resource name of the `WorkerPool`, with format
     *           `projects/{project}/locations/{location}/workerPools/{worker_pool}`.
     *           The value of `{worker_pool}` is provided by `worker_pool_id` in
     *           `CreateWorkerPool` request and the value of `{location}` is determined by
     *           the endpoint accessed.
     *     @type string $display_name
     *           A user-specified, human-readable name for the `WorkerPool`. If provided,
     *           this value must be 1-63 characters.
     *     @type string $uid
     *           Output only. A unique identifier for the `WorkerPool`.
     *     @type array|\Google\Protobuf\Internal\MapField $annotations
     *           User specified annotations. See https://google.aip.dev/128#annotations
     *           for more details such as format and size limitations.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Time at which the request to create the `WorkerPool` was
     *           received.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Time at which the request to update the `WorkerPool` was
     *           received.
     *     @type \Google\Protobuf\Timestamp $delete_time
     *           Output only. Time at which the request to delete the `WorkerPool` was
     *           received.
     *     @type int $state
     *           Output only. `WorkerPool` state.
     *     @type \Google\Cloud\Build\V1\PrivatePoolV1Config $private_pool_v1_config
     *           Legacy Private Pool configuration.
     *     @type string $etag
     *           Output only. Checksum computed by the server. May be sent on update and
     *           delete requests to ensure that the client has an up-to-date value before
     *           proceeding.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Devtools\Cloudbuild\V1\Cloudbuild::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The resource name of the `WorkerPool`, with format
     * `projects/{project}/locations/{location}/workerPools/{worker_pool}`.
     * The value of `{worker_pool}` is provided by `worker_pool_id` in
     * `CreateWorkerPool` request and the value of `{location}` is determined by
     * the endpoint accessed.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The resource name of the `WorkerPool`, with format
     * `projects/{project}/locations/{location}/workerPools/{worker_pool}`.
     * The value of `{worker_pool}` is provided by `worker_pool_id` in
     * `CreateWorkerPool` request and the value of `{location}` is determined by
     * the endpoint accessed.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * A user-specified, human-readable name for the `WorkerPool`. If provided,
     * this value must be 1-63 characters.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * A user-specified, human-readable name for the `WorkerPool`. If provided,
     * this value must be 1-63 characters.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Output only. A unique identifier for the `WorkerPool`.
     *
     * Generated from protobuf field <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. A unique identifier for the `WorkerPool`.
     *
     * Generated from protobuf field <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

    /**
     * User specified annotations. See https://google.aip.dev/128#annotations
     * for more details such as format and size limitations.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAnnotations()
    {
        return $this->annotations;
    }

    /**
     * User specified annotations. See https://google.aip.dev/128#annotations
     * for more details such as format and size limitations.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAnnotations($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->annotations = $arr;

        return $this;
    }

    /**
     * Output only. Time at which the request to create the `WorkerPool` was
     * received.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Time at which the request to create the `WorkerPool` was
     * received.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Time at which the request to update the `WorkerPool` was
     * received.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Time at which the request to update the `WorkerPool` was
     * received.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. Time at which the request to delete the `WorkerPool` was
     * received.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getDeleteTime()
    {
        return $this->delete_time;
    }

    public function hasDeleteTime()
    {
        return isset($this->delete_time);
    }

    public function clearDeleteTime()
    {
        unset($this->delete_time);
    }

    /**
     * Output only. Time at which the request to delete the `WorkerPool` was
     * received.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setDeleteTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->delete_time = $var;

        return $this;
    }

    /**
     * Output only. `WorkerPool` state.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v1.WorkerPool.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. `WorkerPool` state.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v1.WorkerPool.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Build\V1\WorkerPool\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Legacy Private Pool configuration.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config private_pool_v1_config = 12;</code>
     * @return \Google\Cloud\Build\V1\PrivatePoolV1Config|null
     */
    public function getPrivatePoolV1Config()
    {
        return $this->readOneof(12);
    }

    public function hasPrivatePoolV1Config()
    {
        return $this->hasOneof(12);
    }

    /**
     * Legacy Private Pool configuration.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v1.PrivatePoolV1Config private_pool_v1_config = 12;</code>
     * @param \Google\Cloud\Build\V1\PrivatePoolV1Config $var
     * @return $this
     */
    public function setPrivatePoolV1Config($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Build\V1\PrivatePoolV1Config::class);
        $this->writeOneof(12, $var);

        return $this;
    }

    /**
     * Output only. Checksum computed by the server. May be sent on update and
     * delete requests to ensure that the client has an up-to-date value before
     * proceeding.
     *
     * Generated from protobuf field <code>string etag = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Output only. Checksum computed by the server. May be sent on update and
     * delete requests to ensure that the client has an up-to-date value before
     * proceeding.
     *
     * Generated from protobuf field <code>string etag = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getConfig()
    {
        return $this->whichOneof("config");
    }

}

