<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/dataflow/v1beta3/jobs.proto

namespace Google\Cloud\Dataflow\V1beta3;

use UnexpectedValueException;

/**
 * Describes the overall state of a [google.dataflow.v1beta3.Job][google.dataflow.v1beta3.Job].
 *
 * Protobuf type <code>google.dataflow.v1beta3.JobState</code>
 */
class JobState
{
    /**
     * The job's run state isn't specified.
     *
     * Generated from protobuf enum <code>JOB_STATE_UNKNOWN = 0;</code>
     */
    const JOB_STATE_UNKNOWN = 0;
    /**
     * `JOB_STATE_STOPPED` indicates that the job has not
     * yet started to run.
     *
     * Generated from protobuf enum <code>JOB_STATE_STOPPED = 1;</code>
     */
    const JOB_STATE_STOPPED = 1;
    /**
     * `JOB_STATE_RUNNING` indicates that the job is currently running.
     *
     * Generated from protobuf enum <code>JOB_STATE_RUNNING = 2;</code>
     */
    const JOB_STATE_RUNNING = 2;
    /**
     * `JOB_STATE_DONE` indicates that the job has successfully completed.
     * This is a terminal job state.  This state may be set by the Cloud Dataflow
     * service, as a transition from `JOB_STATE_RUNNING`. It may also be set via a
     * Cloud Dataflow `UpdateJob` call, if the job has not yet reached a terminal
     * state.
     *
     * Generated from protobuf enum <code>JOB_STATE_DONE = 3;</code>
     */
    const JOB_STATE_DONE = 3;
    /**
     * `JOB_STATE_FAILED` indicates that the job has failed.  This is a
     * terminal job state.  This state may only be set by the Cloud Dataflow
     * service, and only as a transition from `JOB_STATE_RUNNING`.
     *
     * Generated from protobuf enum <code>JOB_STATE_FAILED = 4;</code>
     */
    const JOB_STATE_FAILED = 4;
    /**
     * `JOB_STATE_CANCELLED` indicates that the job has been explicitly
     * cancelled. This is a terminal job state. This state may only be
     * set via a Cloud Dataflow `UpdateJob` call, and only if the job has not
     * yet reached another terminal state.
     *
     * Generated from protobuf enum <code>JOB_STATE_CANCELLED = 5;</code>
     */
    const JOB_STATE_CANCELLED = 5;
    /**
     * `JOB_STATE_UPDATED` indicates that the job was successfully updated,
     * meaning that this job was stopped and another job was started, inheriting
     * state from this one. This is a terminal job state. This state may only be
     * set by the Cloud Dataflow service, and only as a transition from
     * `JOB_STATE_RUNNING`.
     *
     * Generated from protobuf enum <code>JOB_STATE_UPDATED = 6;</code>
     */
    const JOB_STATE_UPDATED = 6;
    /**
     * `JOB_STATE_DRAINING` indicates that the job is in the process of draining.
     * A draining job has stopped pulling from its input sources and is processing
     * any data that remains in-flight. This state may be set via a Cloud Dataflow
     * `UpdateJob` call, but only as a transition from `JOB_STATE_RUNNING`. Jobs
     * that are draining may only transition to `JOB_STATE_DRAINED`,
     * `JOB_STATE_CANCELLED`, or `JOB_STATE_FAILED`.
     *
     * Generated from protobuf enum <code>JOB_STATE_DRAINING = 7;</code>
     */
    const JOB_STATE_DRAINING = 7;
    /**
     * `JOB_STATE_DRAINED` indicates that the job has been drained.
     * A drained job terminated by stopping pulling from its input sources and
     * processing any data that remained in-flight when draining was requested.
     * This state is a terminal state, may only be set by the Cloud Dataflow
     * service, and only as a transition from `JOB_STATE_DRAINING`.
     *
     * Generated from protobuf enum <code>JOB_STATE_DRAINED = 8;</code>
     */
    const JOB_STATE_DRAINED = 8;
    /**
     * `JOB_STATE_PENDING` indicates that the job has been created but is not yet
     * running.  Jobs that are pending may only transition to `JOB_STATE_RUNNING`,
     * or `JOB_STATE_FAILED`.
     *
     * Generated from protobuf enum <code>JOB_STATE_PENDING = 9;</code>
     */
    const JOB_STATE_PENDING = 9;
    /**
     * `JOB_STATE_CANCELLING` indicates that the job has been explicitly cancelled
     * and is in the process of stopping.  Jobs that are cancelling may only
     * transition to `JOB_STATE_CANCELLED` or `JOB_STATE_FAILED`.
     *
     * Generated from protobuf enum <code>JOB_STATE_CANCELLING = 10;</code>
     */
    const JOB_STATE_CANCELLING = 10;
    /**
     * `JOB_STATE_QUEUED` indicates that the job has been created but is being
     * delayed until launch. Jobs that are queued may only transition to
     * `JOB_STATE_PENDING` or `JOB_STATE_CANCELLED`.
     *
     * Generated from protobuf enum <code>JOB_STATE_QUEUED = 11;</code>
     */
    const JOB_STATE_QUEUED = 11;
    /**
     * `JOB_STATE_RESOURCE_CLEANING_UP` indicates that the batch job's associated
     * resources are currently being cleaned up after a successful run.
     * Currently, this is an opt-in feature, please reach out to Cloud support
     * team if you are interested.
     *
     * Generated from protobuf enum <code>JOB_STATE_RESOURCE_CLEANING_UP = 12;</code>
     */
    const JOB_STATE_RESOURCE_CLEANING_UP = 12;

    private static $valueToName = [
        self::JOB_STATE_UNKNOWN => 'JOB_STATE_UNKNOWN',
        self::JOB_STATE_STOPPED => 'JOB_STATE_STOPPED',
        self::JOB_STATE_RUNNING => 'JOB_STATE_RUNNING',
        self::JOB_STATE_DONE => 'JOB_STATE_DONE',
        self::JOB_STATE_FAILED => 'JOB_STATE_FAILED',
        self::JOB_STATE_CANCELLED => 'JOB_STATE_CANCELLED',
        self::JOB_STATE_UPDATED => 'JOB_STATE_UPDATED',
        self::JOB_STATE_DRAINING => 'JOB_STATE_DRAINING',
        self::JOB_STATE_DRAINED => 'JOB_STATE_DRAINED',
        self::JOB_STATE_PENDING => 'JOB_STATE_PENDING',
        self::JOB_STATE_CANCELLING => 'JOB_STATE_CANCELLING',
        self::JOB_STATE_QUEUED => 'JOB_STATE_QUEUED',
        self::JOB_STATE_RESOURCE_CLEANING_UP => 'JOB_STATE_RESOURCE_CLEANING_UP',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}

