<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/dataflow/v1beta3/templates.proto

namespace Google\Cloud\Dataflow\V1beta3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A request to launch a template.
 *
 * Generated from protobuf message <code>google.dataflow.v1beta3.LaunchTemplateRequest</code>
 */
class LaunchTemplateRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The ID of the Cloud Platform project that the job belongs to.
     *
     * Generated from protobuf field <code>string project_id = 1;</code>
     */
    private $project_id = '';
    /**
     * If true, the request is validated but not actually executed.
     * Defaults to false.
     *
     * Generated from protobuf field <code>bool validate_only = 2;</code>
     */
    private $validate_only = false;
    /**
     * The parameters of the template to launch. This should be part of the
     * body of the POST request.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.LaunchTemplateParameters launch_parameters = 4;</code>
     */
    private $launch_parameters = null;
    /**
     * The [regional endpoint]
     * (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
     * which to direct the request.
     *
     * Generated from protobuf field <code>string location = 5;</code>
     */
    private $location = '';
    protected $template;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $project_id
     *           Required. The ID of the Cloud Platform project that the job belongs to.
     *     @type bool $validate_only
     *           If true, the request is validated but not actually executed.
     *           Defaults to false.
     *     @type string $gcs_path
     *           A Cloud Storage path to the template from which to create
     *           the job.
     *           Must be valid Cloud Storage URL, beginning with 'gs://'.
     *     @type \Google\Cloud\Dataflow\V1beta3\DynamicTemplateLaunchParams $dynamic_template
     *           Params for launching a dynamic template.
     *     @type \Google\Cloud\Dataflow\V1beta3\LaunchTemplateParameters $launch_parameters
     *           The parameters of the template to launch. This should be part of the
     *           body of the POST request.
     *     @type string $location
     *           The [regional endpoint]
     *           (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
     *           which to direct the request.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Dataflow\V1Beta3\Templates::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The ID of the Cloud Platform project that the job belongs to.
     *
     * Generated from protobuf field <code>string project_id = 1;</code>
     * @return string
     */
    public function getProjectId()
    {
        return $this->project_id;
    }

    /**
     * Required. The ID of the Cloud Platform project that the job belongs to.
     *
     * Generated from protobuf field <code>string project_id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setProjectId($var)
    {
        GPBUtil::checkString($var, True);
        $this->project_id = $var;

        return $this;
    }

    /**
     * If true, the request is validated but not actually executed.
     * Defaults to false.
     *
     * Generated from protobuf field <code>bool validate_only = 2;</code>
     * @return bool
     */
    public function getValidateOnly()
    {
        return $this->validate_only;
    }

    /**
     * If true, the request is validated but not actually executed.
     * Defaults to false.
     *
     * Generated from protobuf field <code>bool validate_only = 2;</code>
     * @param bool $var
     * @return $this
     */
    public function setValidateOnly($var)
    {
        GPBUtil::checkBool($var);
        $this->validate_only = $var;

        return $this;
    }

    /**
     * A Cloud Storage path to the template from which to create
     * the job.
     * Must be valid Cloud Storage URL, beginning with 'gs://'.
     *
     * Generated from protobuf field <code>string gcs_path = 3;</code>
     * @return string
     */
    public function getGcsPath()
    {
        return $this->readOneof(3);
    }

    public function hasGcsPath()
    {
        return $this->hasOneof(3);
    }

    /**
     * A Cloud Storage path to the template from which to create
     * the job.
     * Must be valid Cloud Storage URL, beginning with 'gs://'.
     *
     * Generated from protobuf field <code>string gcs_path = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setGcsPath($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Params for launching a dynamic template.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.DynamicTemplateLaunchParams dynamic_template = 6;</code>
     * @return \Google\Cloud\Dataflow\V1beta3\DynamicTemplateLaunchParams|null
     */
    public function getDynamicTemplate()
    {
        return $this->readOneof(6);
    }

    public function hasDynamicTemplate()
    {
        return $this->hasOneof(6);
    }

    /**
     * Params for launching a dynamic template.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.DynamicTemplateLaunchParams dynamic_template = 6;</code>
     * @param \Google\Cloud\Dataflow\V1beta3\DynamicTemplateLaunchParams $var
     * @return $this
     */
    public function setDynamicTemplate($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataflow\V1beta3\DynamicTemplateLaunchParams::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * The parameters of the template to launch. This should be part of the
     * body of the POST request.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.LaunchTemplateParameters launch_parameters = 4;</code>
     * @return \Google\Cloud\Dataflow\V1beta3\LaunchTemplateParameters|null
     */
    public function getLaunchParameters()
    {
        return $this->launch_parameters;
    }

    public function hasLaunchParameters()
    {
        return isset($this->launch_parameters);
    }

    public function clearLaunchParameters()
    {
        unset($this->launch_parameters);
    }

    /**
     * The parameters of the template to launch. This should be part of the
     * body of the POST request.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.LaunchTemplateParameters launch_parameters = 4;</code>
     * @param \Google\Cloud\Dataflow\V1beta3\LaunchTemplateParameters $var
     * @return $this
     */
    public function setLaunchParameters($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataflow\V1beta3\LaunchTemplateParameters::class);
        $this->launch_parameters = $var;

        return $this;
    }

    /**
     * The [regional endpoint]
     * (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
     * which to direct the request.
     *
     * Generated from protobuf field <code>string location = 5;</code>
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * The [regional endpoint]
     * (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
     * which to direct the request.
     *
     * Generated from protobuf field <code>string location = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->location = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getTemplate()
    {
        return $this->whichOneof("template");
    }

}

