<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/v2/agent.proto

namespace Google\Cloud\Dialogflow\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Dialogflow agent is a virtual agent that handles conversations with your
 * end-users. It is a natural language understanding module that understands the
 * nuances of human language. Dialogflow translates end-user text or audio
 * during a conversation to structured data that your apps and services can
 * understand. You design and build a Dialogflow agent to handle the types of
 * conversations required for your system.
 * For more information about agents, see the
 * [Agent guide](https://cloud.google.com/dialogflow/docs/agents-overview).
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.v2.Agent</code>
 */
class Agent extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The project of this agent.
     * Format: `projects/<Project ID>`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $parent = '';
    /**
     * Required. The name of this agent.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $display_name = '';
    /**
     * Required. The default language of the agent as a language tag. See
     * [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes. This field cannot be
     * set by the `Update` method.
     *
     * Generated from protobuf field <code>string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $default_language_code = '';
    /**
     * Optional. The list of all languages supported by this agent (except for the
     * `default_language_code`).
     *
     * Generated from protobuf field <code>repeated string supported_language_codes = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $supported_language_codes;
    /**
     * Required. The time zone of this agent from the
     * [time zone database](https://www.iana.org/time-zones), e.g.,
     * America/New_York, Europe/Paris.
     *
     * Generated from protobuf field <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $time_zone = '';
    /**
     * Optional. The description of this agent.
     * The maximum length is 500 characters. If exceeded, the request is rejected.
     *
     * Generated from protobuf field <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $description = '';
    /**
     * Optional. The URI of the agent's avatar.
     * Avatars are used throughout the Dialogflow console and in the self-hosted
     * [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     *
     * Generated from protobuf field <code>string avatar_uri = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $avatar_uri = '';
    /**
     * Optional. Determines whether this agent should log conversation queries.
     *
     * Generated from protobuf field <code>bool enable_logging = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $enable_logging = false;
    /**
     * Optional. Determines how intents are detected from user queries.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.Agent.MatchMode match_mode = 9 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     * @deprecated
     */
    protected $match_mode = 0;
    /**
     * Optional. To filter out false positive results and still get variety in
     * matched natural language inputs for your agent, you can tune the machine
     * learning classification threshold. If the returned score value is less than
     * the threshold value, then a fallback intent will be triggered or, if there
     * are no fallback intents defined, no intent will be triggered. The score
     * values range from 0.0 (completely uncertain) to 1.0 (completely certain).
     * If set to 0.0, the default of 0.3 is used.
     *
     * Generated from protobuf field <code>float classification_threshold = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $classification_threshold = 0.0;
    /**
     * Optional. API version displayed in Dialogflow console. If not specified,
     * V2 API is assumed. Clients are free to query different service endpoints
     * for different API versions. However, bots connectors and webhook calls will
     * follow the specified API version.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.Agent.ApiVersion api_version = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $api_version = 0;
    /**
     * Optional. The agent tier. If not specified, TIER_STANDARD is assumed.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.Agent.Tier tier = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $tier = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The project of this agent.
     *           Format: `projects/<Project ID>`.
     *     @type string $display_name
     *           Required. The name of this agent.
     *     @type string $default_language_code
     *           Required. The default language of the agent as a language tag. See
     *           [Language
     *           Support](https://cloud.google.com/dialogflow/docs/reference/language)
     *           for a list of the currently supported language codes. This field cannot be
     *           set by the `Update` method.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $supported_language_codes
     *           Optional. The list of all languages supported by this agent (except for the
     *           `default_language_code`).
     *     @type string $time_zone
     *           Required. The time zone of this agent from the
     *           [time zone database](https://www.iana.org/time-zones), e.g.,
     *           America/New_York, Europe/Paris.
     *     @type string $description
     *           Optional. The description of this agent.
     *           The maximum length is 500 characters. If exceeded, the request is rejected.
     *     @type string $avatar_uri
     *           Optional. The URI of the agent's avatar.
     *           Avatars are used throughout the Dialogflow console and in the self-hosted
     *           [Web
     *           Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     *           integration.
     *     @type bool $enable_logging
     *           Optional. Determines whether this agent should log conversation queries.
     *     @type int $match_mode
     *           Optional. Determines how intents are detected from user queries.
     *     @type float $classification_threshold
     *           Optional. To filter out false positive results and still get variety in
     *           matched natural language inputs for your agent, you can tune the machine
     *           learning classification threshold. If the returned score value is less than
     *           the threshold value, then a fallback intent will be triggered or, if there
     *           are no fallback intents defined, no intent will be triggered. The score
     *           values range from 0.0 (completely uncertain) to 1.0 (completely certain).
     *           If set to 0.0, the default of 0.3 is used.
     *     @type int $api_version
     *           Optional. API version displayed in Dialogflow console. If not specified,
     *           V2 API is assumed. Clients are free to query different service endpoints
     *           for different API versions. However, bots connectors and webhook calls will
     *           follow the specified API version.
     *     @type int $tier
     *           Optional. The agent tier. If not specified, TIER_STANDARD is assumed.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\V2\Agent::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The project of this agent.
     * Format: `projects/<Project ID>`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The project of this agent.
     * Format: `projects/<Project ID>`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The name of this agent.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. The name of this agent.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Required. The default language of the agent as a language tag. See
     * [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes. This field cannot be
     * set by the `Update` method.
     *
     * Generated from protobuf field <code>string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDefaultLanguageCode()
    {
        return $this->default_language_code;
    }

    /**
     * Required. The default language of the agent as a language tag. See
     * [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes. This field cannot be
     * set by the `Update` method.
     *
     * Generated from protobuf field <code>string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDefaultLanguageCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->default_language_code = $var;

        return $this;
    }

    /**
     * Optional. The list of all languages supported by this agent (except for the
     * `default_language_code`).
     *
     * Generated from protobuf field <code>repeated string supported_language_codes = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSupportedLanguageCodes()
    {
        return $this->supported_language_codes;
    }

    /**
     * Optional. The list of all languages supported by this agent (except for the
     * `default_language_code`).
     *
     * Generated from protobuf field <code>repeated string supported_language_codes = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSupportedLanguageCodes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->supported_language_codes = $arr;

        return $this;
    }

    /**
     * Required. The time zone of this agent from the
     * [time zone database](https://www.iana.org/time-zones), e.g.,
     * America/New_York, Europe/Paris.
     *
     * Generated from protobuf field <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getTimeZone()
    {
        return $this->time_zone;
    }

    /**
     * Required. The time zone of this agent from the
     * [time zone database](https://www.iana.org/time-zones), e.g.,
     * America/New_York, Europe/Paris.
     *
     * Generated from protobuf field <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setTimeZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->time_zone = $var;

        return $this;
    }

    /**
     * Optional. The description of this agent.
     * The maximum length is 500 characters. If exceeded, the request is rejected.
     *
     * Generated from protobuf field <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. The description of this agent.
     * The maximum length is 500 characters. If exceeded, the request is rejected.
     *
     * Generated from protobuf field <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Optional. The URI of the agent's avatar.
     * Avatars are used throughout the Dialogflow console and in the self-hosted
     * [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     *
     * Generated from protobuf field <code>string avatar_uri = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getAvatarUri()
    {
        return $this->avatar_uri;
    }

    /**
     * Optional. The URI of the agent's avatar.
     * Avatars are used throughout the Dialogflow console and in the self-hosted
     * [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     *
     * Generated from protobuf field <code>string avatar_uri = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setAvatarUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->avatar_uri = $var;

        return $this;
    }

    /**
     * Optional. Determines whether this agent should log conversation queries.
     *
     * Generated from protobuf field <code>bool enable_logging = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getEnableLogging()
    {
        return $this->enable_logging;
    }

    /**
     * Optional. Determines whether this agent should log conversation queries.
     *
     * Generated from protobuf field <code>bool enable_logging = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableLogging($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_logging = $var;

        return $this;
    }

    /**
     * Optional. Determines how intents are detected from user queries.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.Agent.MatchMode match_mode = 9 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     * @deprecated
     */
    public function getMatchMode()
    {
        @trigger_error('match_mode is deprecated.', E_USER_DEPRECATED);
        return $this->match_mode;
    }

    /**
     * Optional. Determines how intents are detected from user queries.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.Agent.MatchMode match_mode = 9 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     * @deprecated
     */
    public function setMatchMode($var)
    {
        @trigger_error('match_mode is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkEnum($var, \Google\Cloud\Dialogflow\V2\Agent\MatchMode::class);
        $this->match_mode = $var;

        return $this;
    }

    /**
     * Optional. To filter out false positive results and still get variety in
     * matched natural language inputs for your agent, you can tune the machine
     * learning classification threshold. If the returned score value is less than
     * the threshold value, then a fallback intent will be triggered or, if there
     * are no fallback intents defined, no intent will be triggered. The score
     * values range from 0.0 (completely uncertain) to 1.0 (completely certain).
     * If set to 0.0, the default of 0.3 is used.
     *
     * Generated from protobuf field <code>float classification_threshold = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return float
     */
    public function getClassificationThreshold()
    {
        return $this->classification_threshold;
    }

    /**
     * Optional. To filter out false positive results and still get variety in
     * matched natural language inputs for your agent, you can tune the machine
     * learning classification threshold. If the returned score value is less than
     * the threshold value, then a fallback intent will be triggered or, if there
     * are no fallback intents defined, no intent will be triggered. The score
     * values range from 0.0 (completely uncertain) to 1.0 (completely certain).
     * If set to 0.0, the default of 0.3 is used.
     *
     * Generated from protobuf field <code>float classification_threshold = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param float $var
     * @return $this
     */
    public function setClassificationThreshold($var)
    {
        GPBUtil::checkFloat($var);
        $this->classification_threshold = $var;

        return $this;
    }

    /**
     * Optional. API version displayed in Dialogflow console. If not specified,
     * V2 API is assumed. Clients are free to query different service endpoints
     * for different API versions. However, bots connectors and webhook calls will
     * follow the specified API version.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.Agent.ApiVersion api_version = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getApiVersion()
    {
        return $this->api_version;
    }

    /**
     * Optional. API version displayed in Dialogflow console. If not specified,
     * V2 API is assumed. Clients are free to query different service endpoints
     * for different API versions. However, bots connectors and webhook calls will
     * follow the specified API version.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.Agent.ApiVersion api_version = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setApiVersion($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dialogflow\V2\Agent\ApiVersion::class);
        $this->api_version = $var;

        return $this;
    }

    /**
     * Optional. The agent tier. If not specified, TIER_STANDARD is assumed.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.Agent.Tier tier = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getTier()
    {
        return $this->tier;
    }

    /**
     * Optional. The agent tier. If not specified, TIER_STANDARD is assumed.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.Agent.Tier tier = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setTier($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dialogflow\V2\Agent\Tier::class);
        $this->tier = $var;

        return $this;
    }

}

